/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.core.util.DCUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMetalLadder
extends BlockDC {
    public static final PropertyBool CLAMP = PropertyBool.func_177716_a((String)"clamp");
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockMetalLadder(String s) {
        super(Material.field_151571_B, s);
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.field_149787_q = false;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)CLAMP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack held;
        if (!player.field_70170_p.field_72995_K && player != null && !DCUtil.isEmpty((ItemStack)(held = player.func_184586_b(hand))) && held.func_77973_b() == Item.func_150898_a((Block)this)) {
            BlockPos target = null;
            for (int i = 1; i < 16; ++i) {
                BlockPos check = pos.func_177981_b(i);
                if (hitY < 0.5f) {
                    check = pos.func_177979_c(i);
                }
                if (!world.func_180495_p(check).func_177230_c().func_176200_f((IBlockAccess)world, check)) continue;
                target = check;
                break;
            }
            if (target != null) {
                EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
                IBlockState set = this.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face);
                world.func_180501_a(target, set, 3);
                DCUtil.reduceStackSize((ItemStack)held, (int)1);
                return true;
            }
        }
        return true;
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing face) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.isSideSolid(state, worldIn, pos, face.func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face != null) {
            BlockPos up = pos.func_177972_a(face);
            return state.func_177226_a((IProperty)CLAMP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, up, face))).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(worldIn.func_175623_d(pos.func_177984_a())));
        }
        return state.func_177226_a((IProperty)CLAMP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face == null) {
            return super.func_185499_a(state, rot);
        }
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176746_e());
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176735_f());
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face == null) {
            return super.func_185471_a(state, mirrorIn);
        }
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.FACING, CLAMP, UPPER});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        switch (face) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return NORTH_AABB;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        return face == side;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (placer != null) {
            EnumFacing face = placer.func_174811_aO();
            state = state.func_177226_a((IProperty)DCState.FACING, (Comparable)face);
        } else {
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                facing = EnumFacing.NORTH;
            }
            state = state.func_177226_a((IProperty)DCState.FACING, (Comparable)facing.func_176734_d());
        }
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)state.func_177230_c());
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 3;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - i)));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 5 - ((EnumFacing)state.func_177229_b((IProperty)DCState.FACING)).func_176745_a();
        return i;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

