/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import com.google.common.collect.Lists;
import defeatedcrow.hac.core.base.BlockDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMetalPillar
extends BlockDC {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    public BlockMetalPillar(String s) {
        super(Material.field_151571_B, s);
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.field_149787_q = false;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing face) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == this) {
            return true;
        }
        return block.isSideSolid(state, worldIn, pos, face);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState state2 = worldIn.func_180495_p(pos);
        EnumFacing.Axis axis = (EnumFacing.Axis)state2.func_177229_b(AXIS);
        if (axis != null) {
            if (axis == EnumFacing.Axis.X || axis == EnumFacing.Axis.Z) {
                return side == EnumFacing.UP || side == EnumFacing.DOWN;
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            EnumFacing face = placer.func_174811_aO();
            state = state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y);
        } else {
            state = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z) : state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
        }
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)state.func_177230_c());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing.Axis axis = EnumFacing.Axis.Y;
        int i = meta & 0xC;
        if (i == 4) {
            axis = EnumFacing.Axis.X;
        } else if (i == 8) {
            axis = EnumFacing.Axis.Z;
        }
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)axis);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.X) {
            i |= 4;
        } else if (axis == EnumFacing.Axis.Z) {
            i |= 8;
        }
        return i;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean b;
        boolean bl = b = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
        return !b && world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

