/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import defeatedcrow.hac.api.placeable.IRapidCollectables;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockScaffold
extends DCSimpleBlock
implements ITexturePath,
IRapidCollectables {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.01, 0.0, 0.01, 0.99, 1.0, 0.99);
    private static String[] names = new String[]{"wood"};

    public BlockScaffold(Material m, String s) {
        super(m, s, 0, false);
        this.func_149675_a(false);
        this.func_149711_c(0.1f);
        this.func_149752_b(15.0f);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int getMaxMeta() {
        return 0;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        if (meta > this.getMaxMeta()) {
            meta = this.getMaxMeta();
        }
        String s = "blocks/build/build_plank";
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.scaffold", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Press shift key: Tooltip expands ===");
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack held;
        if (player != null && !world.field_72995_K && !DCUtil.isEmpty((ItemStack)(held = player.func_184586_b(hand))) && held.func_77973_b() instanceof ItemBlock) {
            ItemBlock tI = (ItemBlock)held.func_77973_b();
            Block tB = tI.func_179223_d();
            if (tB == this || tB instanceof BlockContainer) {
                return false;
            }
            IBlockState tS = tB.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, held.func_77952_i(), (EntityLivingBase)player, hand);
            if (tS == null) {
                return true;
            }
            Set<Object> set = new LinkedHashSet();
            set = MainUtil.getLumberTargetList(world, pos, (Block)this, 100);
            int count = 0;
            for (BlockPos blockPos : set) {
                world.func_175656_a(blockPos, tS);
                if (++count < held.func_190916_E()) continue;
                break;
            }
            if (count > 0) {
                DCUtil.reduceStackSize((ItemStack)held, (int)count);
                ItemStack drop = new ItemStack((Block)this, count);
                EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, drop);
                world.func_72838_d((Entity)entityItem);
            }
            return true;
        }
        return true;
    }

    private double dist(Vec3i v1, Vec3i v2) {
        double d0 = (double)v1.func_177958_n() - (double)v2.func_177958_n();
        double d1 = (double)v1.func_177956_o() - (double)v2.func_177956_o();
        double d2 = (double)v1.func_177952_p() - (double)v2.func_177952_p();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public String getCollectableTool() {
        return "axe";
    }

    public boolean isCollectable(ItemStack item) {
        return !DCUtil.isEmpty((ItemStack)item) && item.func_77973_b() instanceof ItemAxe;
    }

    public int getCollectArea(ItemStack item) {
        return 3;
    }

    public boolean doCollect(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack tool) {
        NonNullList list = NonNullList.func_191196_a();
        this.getDrops(list, (IBlockAccess)world, pos, state, 0);
        for (ItemStack item : list) {
            double x = player.field_70165_t;
            double y = player.field_70163_u + 0.25;
            double z = player.field_70161_v;
            EntityItem drop = new EntityItem(world, x, y, z, item);
            world.func_72838_d((Entity)drop);
        }
        world.func_175698_g(pos);
        return true;
    }
}

