/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.placeable.ISidedTexture;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.core.base.INameSuffix;
import defeatedcrow.hac.core.base.ISidedRenderingBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockSlabBase
extends BlockDC
implements ISidedTexture,
INameSuffix,
ISidedRenderingBlock {
    public static final PropertyBool SIDE = PropertyBool.func_177716_a((String)"side");
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)7);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    public final int maxMeta;
    public final boolean isGlass;
    protected Random rand = new Random();
    public static final String CL_TEX = "dcs_climate:blocks/clear";

    public BlockSlabBase(Material m, String s, int max, boolean glass) {
        super(m, s);
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)));
        if (max < 0 || max > 7) {
            max = 7;
        }
        this.maxMeta = max;
        this.isGlass = glass;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)SIDE) != false ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isGlass) {
            return false;
        }
        boolean top = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)SIDE);
        return top && face == EnumFacing.UP || !top && face == EnumFacing.DOWN;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf(false));
        if (facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5)) {
            return state;
        }
        return state.func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf(true));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockPos check = pos.func_177972_a(side);
        IBlockState state2 = world.func_180495_p(check);
        if (state.func_177230_c() == this && this.isGlassType(state) && this.isGlass) {
            boolean top = (Boolean)state.func_177229_b((IProperty)SIDE);
            if (state2.func_177230_c() == this) {
                boolean top2 = (Boolean)state2.func_177229_b((IProperty)SIDE);
                if (side == EnumFacing.DOWN) {
                    return top || !top2;
                }
                if (side == EnumFacing.UP) {
                    return !top || top2;
                }
                return top != top2;
            }
            if (state2.func_177230_c() instanceof ISidedRenderingBlock) {
                return ((ISidedRenderingBlock)state2.func_177230_c()).isRendered(side, state2);
            }
            if (state2.func_177230_c() instanceof BlockBreakable) {
                return !top && side != EnumFacing.DOWN || top && side != EnumFacing.UP;
            }
            if (!state2.isSideSolid(world, check, side.func_176734_d())) {
                return true;
            }
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && state2.func_185915_l()) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public int func_180651_a(IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)TYPE);
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        return i;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)state.func_177230_c());
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 7;
        boolean f = (meta & 8) != 0;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf(f)).func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(i));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        boolean f;
        int i = 0;
        i = (Integer)state.func_177229_b((IProperty)TYPE);
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        return (f = ((Boolean)state.func_177229_b((IProperty)SIDE)).booleanValue()) ? i : i | 8;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIDE, TYPE});
    }

    public String getTexture(int meta, int side, boolean face) {
        return CL_TEX;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.maxMeta + 1; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isRendered(EnumFacing face, IBlockState state) {
        if (state.func_177230_c() == this) {
            boolean top = (Boolean)state.func_177229_b((IProperty)SIDE);
            return top && face != EnumFacing.DOWN || !top && face != EnumFacing.UP;
        }
        return !this.isGlassType(state);
    }

    private boolean isGlassType(IBlockState state) {
        if (state.func_177230_c() != this) {
            return false;
        }
        int i = (Integer)state.func_177229_b((IProperty)TYPE);
        return i != 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (DCState.getInt((IBlockState)state, (PropertyInteger)TYPE) == 4) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }
}

