/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.main.entity.EntityCution;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSofaBase
extends BlockDC {
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    protected static final AxisAlignedBB AABB_SMALL = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
    protected static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB AABB_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.75, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 0.25, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.25);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.75, 0.5, 0.0, 1.0, 1.0, 1.0);
    private boolean isSmallAABB = false;

    public BlockSofaBase(String s) {
        super(Material.field_151571_B, s);
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.field_149787_q = false;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockSofaBase setSmallAABB() {
        this.isSmallAABB = true;
        return this;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        List list;
        if (!player.field_70170_p.field_72995_K && player != null && hand == EnumHand.MAIN_HAND && (list = world.func_72839_b((Entity)player, AABB_FULL)).isEmpty()) {
            double y1 = this.isSmallAABB ? 0.35 : 0.25;
            EntityCution cution = new EntityCution(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + y1, (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)cution);
            if (player.func_184218_aH()) {
                player.func_184210_p();
            }
            player.func_184220_m((Entity)cution);
        }
        return true;
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return block == this;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face != null) {
            BlockPos left = pos.func_177972_a(face.func_176735_f());
            BlockPos right = pos.func_177972_a(face.func_176746_e());
            return state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, left))).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, right)));
        }
        return state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face == null) {
            return super.func_185499_a(state, rot);
        }
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176746_e());
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176735_f());
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face == null) {
            return super.func_185471_a(state, mirrorIn);
        }
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d()).func_177226_a((IProperty)LEFT, state.func_177229_b((IProperty)RIGHT)).func_177226_a((IProperty)RIGHT, state.func_177229_b((IProperty)LEFT));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d()).func_177226_a((IProperty)RIGHT, state.func_177229_b((IProperty)LEFT)).func_177226_a((IProperty)LEFT, state.func_177229_b((IProperty)RIGHT));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.FACING, LEFT, RIGHT});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isSmallAABB ? AABB_SMALL : AABB_FULL;
    }

    public void getCollisionBoxList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (this.isSmallAABB) {
            BlockSofaBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SMALL);
            return;
        }
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        BlockSofaBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_HALF);
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face != null) {
            switch (face) {
                case EAST: {
                    BlockSofaBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
                    break;
                }
                case NORTH: {
                    BlockSofaBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                    break;
                }
                case SOUTH: {
                    BlockSofaBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
                    break;
                }
                case WEST: {
                    BlockSofaBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
                    break;
                }
            }
        }
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        state = state.func_177226_a((IProperty)DCState.FACING, (Comparable)placer.func_174811_aO());
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)state.func_177230_c());
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 3;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - i)));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 5 - ((EnumFacing)state.func_177229_b((IProperty)DCState.FACING)).func_176745_a();
        return i;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean b;
        boolean bl = b = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
        return !b && world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

