/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import defeatedcrow.hac.api.placeable.ISidedTexture;
import defeatedcrow.hac.core.base.ISidedRenderingBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStairsBase
extends BlockStairs
implements ISidedTexture,
ISidedRenderingBlock {
    public final String TEX;
    public final boolean isGlass;
    public final boolean isForcedRender;
    public boolean isBedrock;

    public BlockStairsBase(IBlockState state, String name, boolean glass, boolean force) {
        super(state);
        this.TEX = "dcs_climate:blocks/" + name;
        this.isGlass = glass;
        this.isForcedRender = force;
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
    }

    public BlockStairsBase setBedRock() {
        this.isBedrock = true;
        return this;
    }

    public String getTexture(int meta, int side, boolean face) {
        return this.TEX;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockPos check = pos.func_177972_a(side);
        IBlockState state2 = world.func_180495_p(check);
        if (this.isForcedRender) {
            return true;
        }
        if (this.isGlass && state.func_177230_c() == this) {
            if (state2.func_177230_c() == this && state.func_177229_b((IProperty)field_176309_a) == state2.func_177229_b((IProperty)field_176309_a)) {
                return false;
            }
            if (state2.func_177230_c() instanceof BlockBreakable) {
                return true;
            }
            if (state2.func_177230_c() instanceof ISidedRenderingBlock) {
                return ((ISidedRenderingBlock)state2.func_177230_c()).isRendered(side, state2);
            }
            if (!state2.isSideSolid(world, check, side.func_176734_d())) {
                return true;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean b;
        boolean bl = b = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
        if (this.isGlass) {
            return !b && world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
        }
        return super.doesSideBlockRendering(state, world, pos, face);
    }

    public boolean isRendered(EnumFacing face, IBlockState state) {
        return !this.isGlass;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.isBedrock) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }
}

