/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.block.build.BlockBedDC;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBedDC
extends DCItem {
    private final BlockBedDC bedBlock;
    private static String[] names = new String[]{"iron", "white", "rattan", "futon", "hammock"};

    public ItemBedDC(BlockBedDC pair) {
        this.bedBlock = pair;
    }

    public int getMaxMeta() {
        return 4;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/block/bed_" + names[meta] + "_item";
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        return names;
    }

    private Block getBed(int meta) {
        switch (meta) {
            case 0: {
                return MainInit.bed;
            }
            case 1: {
                return MainInit.bedWhite;
            }
            case 2: {
                return MainInit.bedRattan;
            }
            case 3: {
                return MainInit.bedFuton;
            }
            case 4: {
                return MainInit.bedHammock;
            }
        }
        return MainInit.bed;
    }

    public EnumActionResult onItemUse2(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        Block block;
        boolean flag;
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        BlockPos head = null;
        BlockPos foot = null;
        EnumFacing headF = facing;
        if (facing == EnumFacing.DOWN) {
            pos = pos.func_177977_b();
        }
        if (facing == EnumFacing.UP) {
            pos = pos.func_177984_a();
        }
        if (headF == EnumFacing.DOWN || headF == EnumFacing.UP) {
            int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            headF = EnumFacing.func_176731_b((int)i);
        }
        head = (flag = (block = (state = world.func_180495_p(pos)).func_177230_c()).func_176200_f((IBlockAccess)world, pos)) ? pos : pos.func_177972_a(headF);
        foot = head.func_177972_a(headF);
        ItemStack item = player.func_184586_b(hand);
        if (!player.func_175151_a(head, facing, item) || !player.func_175151_a(foot, facing, item)) {
            return EnumActionResult.FAIL;
        }
        IBlockState headState = world.func_180495_p(head);
        IBlockState footState = world.func_180495_p(foot);
        if (!headState.func_177230_c().func_176200_f((IBlockAccess)world, head) && !world.func_175623_d(head)) {
            return EnumActionResult.FAIL;
        }
        if (!footState.func_177230_c().func_176200_f((IBlockAccess)world, foot) && !world.func_175623_d(foot)) {
            return EnumActionResult.FAIL;
        }
        IBlockState headNew = this.getBed(item.func_77952_i()).func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)headF).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
        world.func_180501_a(head, headNew, 10);
        world.func_180501_a(foot, headNew.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 10);
        world.func_184133_a(player, pos, SoundType.field_185848_a.func_185841_e(), SoundCategory.BLOCKS, 0.8f, 0.8f);
        world.func_175722_b(head, headState.func_177230_c(), false);
        world.func_175722_b(foot, footState.func_177230_c(), false);
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, head, item);
        }
        item.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.bed", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

