/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.IAirflowTile;
import defeatedcrow.hac.api.energy.IWrenchDC;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.block.device.TileBellow;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBellow
extends BlockTorqueBase
implements IAirflowTile {
    public BlockBellow(String s) {
        super(Material.field_151576_e, s, 0);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileBellow();
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null) {
            TileEntity tile = world.func_175625_s(pos);
            ItemStack held = player.func_184586_b(hand);
            if ((DCUtil.isEmpty((ItemStack)held) || !(held.func_77973_b() instanceof IWrenchDC)) && tile != null && tile instanceof TileBellow) {
                TileBellow crank;
                float add = crank.currentTorque + 1.0f;
                crank = (TileBellow)tile;
                if (add > crank.maxTorque()) {
                    add = crank.maxTorque();
                }
                crank.currentTorque = add;
                return true;
            }
        }
        return super.onRightClick(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public DCAirflow getAirflow(World world, BlockPos pos, BlockPos target) {
        float torque;
        TileBellow fan;
        EnumFacing face;
        boolean active;
        TileEntity tile = world.func_175625_s(target);
        if (tile != null && tile instanceof TileBellow && (active = this.isActive(face = (fan = (TileBellow)tile).getBaseSide(), pos, target)) && (torque = fan.getCurrentTorque()) > 0.0f) {
            return DCAirflow.WIND;
        }
        return DCAirflow.TIGHT;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (placer != null) {
            EnumFacing face = placer.func_174811_aO();
            if (placer.field_70125_A < -75.0f) {
                face = EnumFacing.UP;
            } else if (placer.field_70125_A > 75.0f) {
                face = EnumFacing.DOWN;
            }
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)face));
        } else {
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)facing));
        }
        return state;
    }

    boolean isActive(EnumFacing face, BlockPos to, BlockPos from) {
        if (to.equals((Object)from)) {
            return true;
        }
        switch (face) {
            case DOWN: {
                return to.func_177984_a().equals((Object)from);
            }
            case UP: {
                return to.func_177977_b().equals((Object)from);
            }
            case NORTH: {
                return to.func_177968_d().equals((Object)from);
            }
            case SOUTH: {
                return to.func_177978_c().equals((Object)from);
            }
            case WEST: {
                return to.func_177974_f().equals((Object)from);
            }
            case EAST: {
                return to.func_177976_e().equals((Object)from);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.TORQUE.getLocalizedName() + ": 1.0F /s or " + DCName.RIGHT_CLICK.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.AIR.getLocalizedName() + ": " + TextFormatting.AQUA.toString() + "WIND");
            tooltip.add(DCName.RANGE.getLocalizedName() + ": " + I18n.func_135052_a((String)"dcs.tip.forward_only", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

