/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateSupplier;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.block.device.BlockNormalChamber;
import defeatedcrow.hac.main.block.device.TileFirestand;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFirestand
extends BlockNormalChamber {
    public BlockFirestand(String s) {
        super(Material.field_151571_B, s, 3);
        this.func_149675_a(true);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFirestand();
    }

    @Override
    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (BlockFirestand.isLit((IBlockAccess)world, pos)) {
            boolean ext = false;
            if (world.func_72896_J()) {
                ext = true;
            } else {
                ClimateSupplier sup = new ClimateSupplier(world, pos);
                if (sup.get().getHumidity() == DCHumidity.UNDERWATER) {
                    ext = true;
                } else if (sup.get().getHumidity() == DCHumidity.WET) {
                    boolean bl = ext = world.field_73012_v.nextInt(4 + sup.get().getAirflow().getID() * 3) == 0;
                }
            }
            if (ext) {
                BlockFirestand.changeLitState(world, pos, false);
                world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.8f, 1.0f, false);
            }
        }
    }

    @Override
    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (BlockFirestand.isLit((IBlockAccess)world, pos) && player != null && hand == EnumHand.MAIN_HAND) {
            if (!world.field_72995_K) {
                BlockFirestand.changeLitState(world, pos, false);
            }
            player.func_184185_a(SoundEvents.field_187646_bt, 0.8f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public DCHeatTier getHeatTier(World world, BlockPos from, BlockPos to) {
        IBlockState state = world.func_180495_p(to);
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (meta == 1) {
            return DCHeatTier.KILN;
        }
        return DCHeatTier.NORMAL;
    }

    public static void changeLitState(World world, BlockPos pos, boolean f) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == MainInit.firestand) {
            if (f) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)), 3);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(2)), 3);
            }
        }
    }

    public static boolean isLit(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != MainInit.firestand) {
            return false;
        }
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        return meta == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state != null && BlockFirestand.isLit((IBlockAccess)world, pos)) {
            int c = ClimateMain.proxy.getParticleCount();
            if (ClimateMain.proxy.getParticleCount() > 0 && rand.nextInt(c) == 0) {
                double x = (double)pos.func_177958_n() + 0.5 + rand.nextDouble() * 0.15;
                double y = (double)pos.func_177956_o() + 0.75 + rand.nextDouble() * 0.15;
                double z = (double)pos.func_177952_p() + 0.5 + rand.nextDouble() * 0.15;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.firestand1", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.RED.toString() + "KILN");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.firestand2", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    @Override
    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    @Override
    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return 0;
    }

    public static void changePowerState(World world, BlockPos pos) {
    }

    @Override
    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
    }
}

