/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IHeatTile;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.block.device.TileGeyser;
import defeatedcrow.hac.main.client.particle.ParticleCloudDC;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGeyser
extends BlockTorqueBase
implements IHeatTile {
    public BlockGeyser(String s) {
        super(Material.field_151576_e, s, 0);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 4);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileGeyser();
    }

    public DCHeatTier getHeatTier(World world, BlockPos targrt, BlockPos thisTile) {
        return DCHeatTier.OVEN;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)facing));
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.NON_POWERED.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add("Steam: 0 ~ 100 mB/s");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.RED.toString() + "OVEN");
            tooltip.add(DCName.AIR.getLocalizedName() + ": " + TextFormatting.AQUA.toString() + "WIND");
            tooltip.add(DCName.RANGE.getLocalizedName() + ": " + I18n.func_135052_a((String)"dcs.tip.forward_only", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.geyser", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state != null && state.func_177230_c() == this) {
            int c = ClimateMain.proxy.getParticleCount();
            EnumSide side = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE);
            if (side == null) {
                side = EnumSide.UP;
            }
            if (ClimateMain.proxy.getParticleCount() > 0) {
                for (int i = 0; i < ClimateMain.proxy.getParticleCount() / 2; ++i) {
                    double x = (double)pos.func_177958_n() + 0.25 + rand.nextDouble() * 0.5;
                    double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 0.5;
                    double z = (double)pos.func_177952_p() + 0.25 + rand.nextDouble() * 0.5;
                    double s = 0.2 + rand.nextDouble() * 0.2;
                    double dx = s * (double)side.face.func_82601_c();
                    double dy = s * (double)side.face.func_96559_d();
                    double dz = s * (double)side.face.func_82599_e();
                    Particle cloud = new ParticleCloudDC.Factory().func_178902_a(0, world, x, y, z, dx, dy, dz, null);
                    FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(cloud);
                }
            }
        }
    }
}

