/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.climate.IHeatTile;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.block.device.TileChamberBase;
import defeatedcrow.hac.main.block.device.TileNormalChamber;
import defeatedcrow.hac.main.util.DCName;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNormalChamber
extends DCTileBlock
implements IHeatTile {
    public BlockNormalChamber(Material m, String s, int max) {
        super(m, s, max);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        return face != null && side != face.func_176734_d();
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!player.field_70170_p.field_72995_K && player != null && hand == EnumHand.MAIN_HAND && (tile = world.func_175625_s(pos)) instanceof TileChamberBase) {
            player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileNormalChamber();
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public DCHeatTier getHeatTier(World world, BlockPos from, BlockPos to) {
        IBlockState state = world.func_180495_p(to);
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (meta == 1) {
            TileEntity t = world.func_175625_s(to);
            if (t instanceof TileChamberBase) {
                DCHeatTier heat = ((TileChamberBase)t).getCurrentHeatTier();
                return heat;
            }
            return DCHeatTier.BOIL;
        }
        return DCHeatTier.NORMAL;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state) & 3;
        return meta == 1 ? 15 : 0;
    }

    public static void changeLitState(World world, BlockPos pos, boolean f) {
        IBlockState state = world.func_180495_p(pos);
        int m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (m >= 0) {
            int power = m & 2;
            if (f) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1 + power)), 3);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(power)), 3);
            }
        }
    }

    public static void changePowerState(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (m >= 0) {
            boolean power;
            int lit = m & 1;
            boolean bl = power = (m & 2) == 0;
            if (power) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit + 2)), 3);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit)), 3);
            }
        }
    }

    public static boolean isLit(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        return meta == 1 || meta == 3;
    }

    public static boolean isPower(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        return meta == 0 || meta == 1;
    }

    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        boolean flag;
        if (!world.field_72995_K && ((flag = world.func_175640_z(pos)) || block.func_176223_P().func_185897_m())) {
            boolean power;
            int m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
            int lit = m & 1;
            boolean flag2 = m == 1;
            boolean bl = power = (m & 2) != 0;
            if (flag && !power) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit + 2)), 3);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
            } else if (!flag && power) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit)), 3);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.5f);
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state != null && BlockNormalChamber.isLit((IBlockAccess)world, pos)) {
            int c = ClimateMain.proxy.getParticleCount();
            if (ClimateMain.proxy.getParticleCount() > 0 && rand.nextInt(c) == 0) {
                EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING).func_176734_d();
                double x = (double)pos.func_177958_n() + 0.5 + (double)face.func_82601_c() * 0.5 + rand.nextDouble() * 0.15;
                double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 0.15;
                double z = (double)pos.func_177952_p() + 0.5 + (double)face.func_82599_e() * 0.5 + rand.nextDouble() * 0.15;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.BOLD.toString() + "Tier 1");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.FUEL_SOLID.getLocalizedName());
            tooltip.add(DCName.AIR.getLocalizedName() + ": " + TextFormatting.AQUA.toString() + "WIND");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.RED.toString() + "SMELTING");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.chamber", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.chamber2", (Object[])new Object[0]));
            tooltip.add(DCName.RS.getLocalizedName() + ": " + DCName.TURN_OFF.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }
}

