/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import com.google.common.collect.Lists;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.block.device.TileSink;
import defeatedcrow.hac.main.util.DCName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSink
extends DCTileBlock {
    protected static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_DOUBLE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public final boolean isFull;

    public BlockSink(String s, boolean full) {
        super(Material.field_151571_B, s, 0);
        this.isFull = full;
        this.func_149675_a(true);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isFull) {
            return AABB_DOUBLE;
        }
        return AABB_HALF;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSink();
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            ItemStack held = player.func_184586_b(hand);
            if (tile instanceof TileSink && !DCUtil.isEmpty((ItemStack)held) && held.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, side)) {
                if (!player.field_70170_p.field_72995_K) {
                    DCFluidUtil.onActivateDCTank((TileEntity)tile, (ItemStack)held, (World)world, (IBlockState)state, (EnumFacing)side, (EntityPlayer)player);
                }
                player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.NON_POWERED.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.sink", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

