/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import defeatedcrow.hac.core.base.DCItemBlock;
import defeatedcrow.hac.main.block.fluid.FluidItemBlockWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPail
extends DCItemBlock {
    public ItemPail(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public String[] getNameSuffix() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(TextFormatting.BOLD.toString() + "Tier 1");
        IFluidHandlerItem cont = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cont != null && cont.getTankProperties() != null && cont.getTankProperties().length > 0) {
            FluidStack f = cont.getTankProperties()[0].getContents();
            if (f != null && f.getFluid() != null) {
                tooltip.add(TextFormatting.BOLD.toString() + "CONTAINED FLUID");
                tooltip.add("Fluid: " + f.getLocalizedName());
                tooltip.add("Amount: " + f.amount + " mB");
            } else {
                tooltip.add(TextFormatting.BOLD.toString() + "CONTAINED FLUID");
                tooltip.add("Fluid: Empty");
                tooltip.add("Amount: 0 mB");
            }
        } else {
            tooltip.add(TextFormatting.BOLD.toString() + "CONTAINED FLUID");
            tooltip.add("Fluid: Empty");
            tooltip.add("Amount: 0 mB");
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapWrapper(stack);
    }

    private class CapWrapper
    implements ICapabilityProvider {
        private final ItemStack cont;

        private CapWrapper(ItemStack item) {
            this.cont = item;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)((Object)new FluidItemBlockWrapper(this.cont, 18000, "Tank"));
            }
            return null;
        }
    }
}

