/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.base.ClimateReceiverLockable;
import defeatedcrow.hac.core.base.DCInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileChamberBase
extends ClimateReceiverLockable
implements ISidedInventory {
    protected int currentBurnTime = 0;
    protected int maxBurnTime = 1;
    protected int currentClimate = DCHeatTier.OVEN.getID();
    protected DCInventory invs = new DCInventory(4);
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.invs.readFromNBT(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.currentClimate = tag.func_74771_c("Climate");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        tag.func_74774_a("Climate", (byte)this.currentClimate);
        this.invs.writeToNBT(tag);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        tag.func_74774_a("Climate", (byte)this.currentClimate);
        this.invs.writeToNBT(tag);
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.invs.readFromNBT(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.currentClimate = tag.func_74771_c("Climate");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean isActive() {
        return this.currentBurnTime > 0;
    }

    public int getCurrentBurnTime() {
        return this.currentBurnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public int getCurrentHeatID() {
        return this.currentClimate;
    }

    public void setCurrentBurnTime(int i) {
        this.currentBurnTime = i;
    }

    public void setMaxBurnTime(int i) {
        this.maxBurnTime = i;
    }

    public void setCurrentHeatID(int i) {
        this.currentClimate = i;
    }

    public DCHeatTier getCurrentHeatTier() {
        return DCHeatTier.getTypeByID((int)this.currentClimate);
    }

    public int getFuel(ItemStack item) {
        return TileChamberBase.getBurnTime(item);
    }

    public abstract boolean isSuitableClimate();

    public abstract List<String> climateSuitableMassage();

    public static int getBurnTime(ItemStack item) {
        int i = TileEntityFurnace.func_145952_a((ItemStack)item);
        int i2 = item.func_77973_b().getItemBurnTime(item);
        if (i2 > 0) {
            int ret2 = i2 / 4;
            if (ret2 > 0 && ret2 < 50) {
                ret2 = 50;
            }
            return ret2;
        }
        int ret = i / 4;
        if (ret > 0 && ret < 50) {
            ret = 50;
        }
        return ret;
    }

    protected int[] slotsTop() {
        return new int[]{0};
    }

    protected int[] slotsBottom() {
        return new int[]{1, 2, 3};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3};
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.invs.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.invs.func_70298_a(i, num);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.invs.func_70299_a(i, stack);
    }

    public String func_70005_c_() {
        return "dcs.gui.device.chamber";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i > 0 ? false : TileChamberBase.getBurnTime(stack) > 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.slotsBottom() : (side == EnumFacing.UP ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 0;
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        return DCInventory.isItemStackable((ItemStack)target, (ItemStack)current);
    }

    public void incrStackInSlot(int i, ItemStack input) {
        this.invs.incrStackInSlot(i, input);
    }

    public ItemStack func_70304_b(int i) {
        return this.invs.func_70304_b(i);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
            case 2: {
                return this.currentClimate;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            case 2: {
                this.currentClimate = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.invs.func_174888_l();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }
}

