/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.device;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.block.device.BlockNormalChamber;
import defeatedcrow.hac.main.block.device.TileChamberBase;
import defeatedcrow.hac.main.client.gui.ContainerNormalChamber;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;

public class TileNormalChamber
extends TileChamberBase {
    private int lastTier = 0;
    private int lastBurn = 0;

    public void updateTile() {
        if (!this.func_145831_w().field_72995_K) {
            DCAirflow air = DCAirflow.TIGHT;
            if (this.current != null) {
                air = this.current.getAirflow();
            }
            this.currentClimate = air.getID() == 3 ? DCHeatTier.SMELTING.getID() : (air.getID() == 2 ? DCHeatTier.KILN.getID() : DCHeatTier.OVEN.getID());
            if (this.currentBurnTime == 0 && !DCUtil.isEmpty((ItemStack)this.func_70301_a(0)) && this.getFuel(this.func_70301_a(0)) > 0) {
                ItemStack copy = this.func_70301_a(0).func_77946_l();
                ItemStack cont = copy.func_77973_b().getContainerItem(copy);
                if (DCUtil.isEmpty((ItemStack)cont)) {
                    cont = DCFluidUtil.getEmptyCont((ItemStack)copy);
                }
                if (DCUtil.isEmpty((ItemStack)cont)) {
                    cont = new ItemStack(MainInit.miscDust, 1, 5);
                }
                boolean flag = false;
                if (this.canInsertResult(cont) > 0) {
                    this.currentBurnTime = this.getFuel(copy);
                    this.maxBurnTime = this.getFuel(copy);
                    this.func_70298_a(0, 1);
                    this.insertResult(cont);
                    this.func_70296_d();
                }
            }
            if (BlockNormalChamber.isLit((IBlockAccess)this.func_145831_w(), this.func_174877_v()) != this.isActive()) {
                BlockNormalChamber.changeLitState(this.func_145831_w(), this.func_174877_v(), this.isActive());
            }
        }
        super.updateTile();
    }

    public void onTickUpdate() {
    }

    protected void onServerUpdate() {
        if (this.currentBurnTime > 0 && BlockNormalChamber.isPower((IBlockAccess)this.func_145831_w(), this.func_174877_v())) {
            --this.currentBurnTime;
        }
    }

    @Override
    public int getFuel(ItemStack item) {
        return TileNormalChamber.getBurnTime(item);
    }

    protected int canInsertResult(ItemStack item) {
        int ret = 0;
        if (DCUtil.isEmpty((ItemStack)item)) {
            return 0;
        }
        for (int i = 1; i < this.func_70302_i_(); ++i) {
            ret = DCUtil.isEmpty((ItemStack)this.func_70301_a(i)) ? item.func_190916_E() : TileNormalChamber.isItemStackable(item, this.func_70301_a(i));
            if (ret <= 0) continue;
            return ret;
        }
        return 0;
    }

    protected int insertResult(ItemStack item) {
        if (DCUtil.isEmpty((ItemStack)item)) {
            return 0;
        }
        for (int i = 1; i < this.func_70302_i_(); ++i) {
            if (DCUtil.isEmpty((ItemStack)this.func_70301_a(i))) {
                this.incrStackInSlot(i, item.func_77946_l());
                return item.func_190916_E();
            }
            int size = TileNormalChamber.isItemStackable(item, this.func_70301_a(i));
            if (size <= 0) continue;
            DCUtil.addStackSize((ItemStack)this.func_70301_a(i), (int)size);
            return size;
        }
        return 0;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public String func_174875_k() {
        return "dcs_climate:normal_chamber";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerNormalChamber(this, playerInventory);
    }

    public boolean func_191420_l() {
        return this.invs.func_191420_l();
    }

    @Override
    public boolean isSuitableClimate() {
        return this.currentClimate == DCHeatTier.SMELTING.getID();
    }

    @Override
    public List<String> climateSuitableMassage() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isSuitableClimate()) {
            list.add(I18n.func_74838_a((String)"dcs.gui.message.suitable"));
        } else {
            list.add(I18n.func_74838_a((String)"dcs.gui.message.require.wind"));
            list.add(I18n.func_74838_a((String)"dcs.gui.message.require.wind2"));
        }
        return list;
    }
}

