/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.fluid;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IAirflowTile;
import defeatedcrow.hac.api.climate.IHeatTile;
import defeatedcrow.hac.api.climate.IHumidityTile;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.client.particle.ParticleCloudDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DCFluidBlockBase
extends BlockFluidClassic
implements ITexturePath,
IHeatTile,
IHumidityTile,
IAirflowTile {
    protected final String name;
    protected boolean canDisplace = false;

    public DCFluidBlockBase(Fluid fluid, String n) {
        super(fluid, Material.field_151586_h);
        this.name = n;
    }

    public DCFluidBlockBase(Fluid fluid, String n, Material mat) {
        super(fluid, mat);
        this.name = n;
    }

    public DCFluidBlockBase setCanDisplace() {
        this.canDisplace = true;
        return this;
    }

    public String getTexPath(int meta, boolean isFull) {
        String b = "dcs_climate:blocks/fluid/";
        return b + this.name;
    }

    public DCAirflow getAirflow(World world, BlockPos to, BlockPos from) {
        return DCAirflow.TIGHT;
    }

    public DCHumidity getHumidity(World world, BlockPos to, BlockPos from) {
        if (this.stack.getFluid() != null && this.stack.getFluid().isGaseous()) {
            return DCHumidity.NORMAL;
        }
        return DCHumidity.UNDERWATER;
    }

    public DCHeatTier getHeatTier(World world, BlockPos to, BlockPos from) {
        if (this.stack.getFluid() != null) {
            int temp = this.stack.getFluid().getTemperature();
            return DCFluidBlockBase.getFluidHeatTier(temp);
        }
        return DCHeatTier.NORMAL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state != null && state.func_177230_c() == this && this.stack.getFluid() != null) {
            int temp;
            int c = ClimateMain.proxy.getParticleCount();
            if (ClimateMain.proxy.getParticleCount() > 0 && rand.nextInt(c) == 0 && (temp = this.stack.getFluid().getTemperature()) > 320) {
                double x = (double)pos.func_177958_n() + 0.5 + rand.nextDouble() * 0.25;
                double y = (double)pos.func_177956_o() + 0.85 + rand.nextDouble() * 0.25;
                double z = (double)pos.func_177952_p() + 0.5 + rand.nextDouble() * 0.25;
                double dx = 0.0;
                double dy = 0.0;
                double dz = 0.0;
                Particle cloud = new ParticleCloudDC.Factory().func_178902_a(0, world, x, y, z, dx, dy, dz, null);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(cloud);
            }
        }
    }

    public static DCHeatTier getFluidHeatTier(int temp) {
        return DCHeatTier.getTypeByTemperature((int)temp);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity != null && entity instanceof EntityLivingBase && !world.field_72995_K) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (this.getFluid() != null && this.getFluid() == MainInit.hotSpring) {
                Collection effs = living.func_70651_bq();
                if (effs.isEmpty()) {
                    return;
                }
                ArrayList<Potion> removes = new ArrayList<Potion>();
                for (PotionEffect potionEffect : effs) {
                    if (potionEffect == null || potionEffect.func_188419_a() == null || !potionEffect.func_188419_a().func_76398_f()) continue;
                    removes.add(potionEffect.func_188419_a());
                }
                for (Potion potion : removes) {
                    living.func_184589_d(potion);
                }
            }
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockLiquid) {
            if (state.func_185904_a() == Material.field_151586_h && this.getFluid() == MainInit.nitrogen) {
                return true;
            }
        } else if (state.func_185904_a().func_76224_d()) {
            return state.func_177230_c().func_176201_c(state) > 7;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockLiquid && state.func_185904_a() == Material.field_151586_h && this.getFluid() == MainInit.nitrogen) {
            return true;
        }
        if (state.func_185904_a().func_76224_d()) {
            return state.func_177230_c().func_176201_c(state) > 7;
        }
        return super.displaceIfPossible(world, pos);
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockLiquid && state.func_185904_a() == Material.field_151586_h && this.getFluid() == MainInit.nitrogen) {
            world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 3);
            return;
        }
        super.flowIntoBlock(world, pos, meta);
    }

    @Deprecated
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)15);
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(i));
    }
}

