/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.fluid;

import defeatedcrow.hac.core.util.DCUtil;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidDropItemDC
implements IFluidHandlerItem,
ICapabilityProvider {
    protected final ItemStack container;
    private final String contain;

    public FluidDropItemDC(ItemStack container, String name) {
        this.container = container;
        this.contain = name;
    }

    @Nullable
    public FluidStack getFluid() {
        Fluid fluid = FluidRegistry.getFluid((String)this.contain);
        if (fluid != null) {
            return new FluidStack(fluid, 200);
        }
        return null;
    }

    protected void setFluid(FluidStack fluid) {
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 200)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount < 200 || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain < 200) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null || !this.canDrainFluidType(contained)) {
            return null;
        }
        int drainAmount = 200;
        FluidStack drained = contained.copy();
        drained.amount = 200;
        if (doDrain) {
            this.setContainerToEmpty();
        }
        return drained;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return false;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    protected void setContainerToEmpty() {
        DCUtil.reduceStackSize((ItemStack)this.container, (int)1);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

