/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.fluid;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class FluidItemBlockWrapper
extends FluidHandlerItemStack {
    public final String key;

    public FluidItemBlockWrapper(ItemStack container, int capacity, String k) {
        super(container, capacity);
        this.key = k;
    }

    @Nullable
    public FluidStack getFluid() {
        NBTTagCompound nbt = this.container.func_77978_p();
        if (nbt != null && nbt.func_74764_b(this.key)) {
            NBTTagList list = nbt.func_150295_c(this.key, 10);
            NBTTagCompound nbt2 = list.func_150305_b(0);
            if (!nbt2.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt2);
                return fluid;
            }
            return null;
        }
        return null;
    }

    protected void setFluid(FluidStack fluid) {
        if (!this.container.func_77942_o()) {
            this.container.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        NBTTagCompound nbt2 = new NBTTagCompound();
        if (fluid != null) {
            fluid.writeToNBT(nbt2);
        } else {
            nbt2.func_74778_a("Empty", "");
        }
        list.func_74742_a((NBTBase)nbt2);
        this.container.func_77978_p().func_74782_a(this.key, (NBTBase)list);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.capacity)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null) {
            int fillAmount = Math.min(this.capacity, resource.amount);
            if (doFill) {
                FluidStack filled = resource.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.capacity - contained.amount, resource.amount);
            if (doFill && fillAmount > 0) {
                contained.amount += fillAmount;
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount <= 0 || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || maxDrain <= 0) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null || contained.amount <= 0 || !this.canDrainFluidType(contained)) {
            return null;
        }
        int drainAmount = Math.min(contained.amount, maxDrain);
        FluidStack drained = contained.copy();
        drained.amount = drainAmount;
        if (doDrain) {
            contained.amount -= drainAmount;
            if (contained.amount == 0) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    protected void setContainerToEmpty() {
        this.container.func_77978_p().func_82580_o(this.key);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)((Object)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null));
    }
}

