/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.fluid;

import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.fluid.DCTank;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class SidedFluidTankWrapper
implements IFluidHandler,
ICapabilityProvider {
    protected final DCTank tank;
    private final boolean drainOnly;
    private final boolean fillOnly;
    protected EnumSide side;

    public SidedFluidTankWrapper(DCTank t1, boolean drain, boolean fill) {
        this.tank = t1;
        this.drainOnly = drain;
        this.fillOnly = fill;
    }

    public SidedFluidTankWrapper setSide(EnumSide s) {
        this.side = s;
        return this;
    }

    public DCTank getTank() {
        if (this.tank != null) {
            return this.tank;
        }
        return null;
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.getTank() != null && this.getTank().getFluid() != null) {
            return this.getTank().getFluid();
        }
        return null;
    }

    protected void setFluid(FluidStack fluid) {
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.getTank() == null) {
            return new FluidTankProperties[0];
        }
        return new FluidTankProperties[]{new FluidTankProperties(this.getTank().getFluid(), this.getTank().getCapacity())};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.drainOnly || resource == null) {
            return 0;
        }
        return this.getTank().fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.getTank() == null || this.fillOnly || resource == null) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getTank() == null || this.fillOnly || maxDrain <= 0) {
            return null;
        }
        return this.getTank().drain(maxDrain, doDrain);
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : null);
    }
}

