/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.ores;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.placeable.IRapidCollectables;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.IHeatTreatment;
import defeatedcrow.hac.main.api.MainAPIManager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDusts
extends DCSimpleBlock
implements ITexturePath,
IRapidCollectables {
    private static String[] names = new String[]{"copper", "zinc", "nickel", "silver", "brass", "steel", "nickelsilver", "magnet", "tin", "bronze", "sus", "gold", "titanium", "aluminium", "bismuth", "bscco"};

    public BlockDusts(Material m, String s, int max) {
        super(m, s, max, true);
        this.func_149675_a(true);
        this.func_149711_c(1.5f);
        this.func_149752_b(15.0f);
    }

    public int func_149738_a(World world) {
        return 40;
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        if (clm != null) {
            Block ret;
            IBlockState retS;
            ItemStack output;
            DCHeatTier heat = clm.getHeat();
            DCHumidity hum = clm.getHumidity();
            DCAirflow air = clm.getAirflow();
            int meta = this.func_180651_a(state);
            ItemStack check = new ItemStack((Block)this, 1, meta);
            IHeatTreatment recipe = MainAPIManager.heatTreatmentRegister.getRecipe(check);
            if (recipe != null && !DCUtil.isEmpty((ItemStack)(output = (ItemStack)recipe.getCurrentOutput(check, clm).func_188398_b())) && output.func_77973_b() instanceof ItemBlock && world.func_180501_a(pos, retS = (ret = ((ItemBlock)output.func_77973_b()).func_179223_d()).func_176203_a(output.func_77960_j()), 2)) {
                world.func_175685_c(pos, ret, true);
                if (this.playSEOnChanging(meta)) {
                    world.func_184133_a(null, pos, this.getSE(meta), SoundCategory.BLOCKS, 0.8f, 2.0f);
                    DCLogger.debugLog((String)("Heat Treatment: " + output.func_82833_r()));
                }
                return true;
            }
        }
        return super.onClimateChange(world, pos, state, clm);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public static ItemStack[] containedItem() {
        ItemStack[] ret = new ItemStack[]{new ItemStack(MainInit.oreDust, 9, 0), new ItemStack(MainInit.oreDust, 9, 1), new ItemStack(MainInit.oreDust, 9, 2), new ItemStack(MainInit.oreDust, 9, 3), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(MainInit.oreDust, 9, 8), ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(MainInit.oreDust, 9, 4), ItemStack.field_190927_a, new ItemStack(MainInit.oreDust, 9, 11), new ItemStack(MainInit.oreDust, 9, 12), ItemStack.field_190927_a};
        return ret;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        if (meta >= names.length) {
            meta = names.length - 1;
        }
        String s = "blocks/ores/dustblock_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String getCollectableTool() {
        return "shovel";
    }

    public boolean isCollectable(ItemStack item) {
        return !DCUtil.isEmpty((ItemStack)item) && item.func_77973_b() instanceof ItemSpade;
    }

    public int getCollectArea(ItemStack item) {
        return 1;
    }

    public boolean doCollect(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack tool) {
        NonNullList list = NonNullList.func_191196_a();
        this.getDrops(list, (IBlockAccess)world, pos, state, 0);
        for (ItemStack item : list) {
            double x = player.field_70165_t;
            double y = player.field_70163_u + 0.25;
            double z = player.field_70161_v;
            EntityItem drop = new EntityItem(world, x, y, z, item);
            world.func_72838_d((Entity)drop);
        }
        world.func_175698_g(pos);
        return true;
    }
}

