/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.ores;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.placeable.IRapidCollectables;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.IHeatTreatment;
import defeatedcrow.hac.main.api.MainAPIManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHeatingMetal
extends DCSimpleBlock
implements ITexturePath,
IRapidCollectables {
    private static String[] names = new String[]{"steel_heating", "steel_cooling", "steel_fail", "sus_heating", "sus_cooling", "sus_fail", "titanium_heating", "titanium_cooling", "titanium_fail", "toolsteel_heating", "toolsteel_cooling", "toolsteel_fail", "mangalloy_heating", "mangalloy_cooling", "mangalloy_fail"};

    public BlockHeatingMetal(Material m, String s, int max) {
        super(m, s, max, true);
        this.func_149675_a(true);
        this.func_149711_c(1.5f);
        this.func_149752_b(15.0f);
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        if (clm != null) {
            Block ret;
            IBlockState retS;
            ItemStack output;
            DCHeatTier heat = clm.getHeat();
            DCHumidity hum = clm.getHumidity();
            DCAirflow air = clm.getAirflow();
            int meta = this.func_180651_a(state);
            ItemStack check = new ItemStack((Block)this, 1, meta);
            IHeatTreatment recipe = MainAPIManager.heatTreatmentRegister.getRecipe(check);
            if (recipe != null && !DCUtil.isEmpty((ItemStack)(output = (ItemStack)recipe.getCurrentOutput(check, clm).func_188398_b())) && output.func_77973_b() instanceof ItemBlock && world.func_180501_a(pos, retS = (ret = ((ItemBlock)output.func_77973_b()).func_179223_d()).func_176203_a(output.func_77960_j()), 2)) {
                world.func_175685_c(pos, ret, true);
                if (this.playSEOnChanging(meta)) {
                    world.func_184133_a(null, pos, this.getSE(meta), SoundCategory.BLOCKS, 0.8f, 2.0f);
                    DCLogger.debugLog((String)("Heat Treatment: " + output.func_82833_r()));
                }
                return true;
            }
        }
        return super.onClimateChange(world, pos, state, clm);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        if (meta >= names.length) {
            meta = names.length - 1;
        }
        String s = "blocks/ores/metal_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String getCollectableTool() {
        return "shovel";
    }

    public boolean isCollectable(ItemStack item) {
        return !DCUtil.isEmpty((ItemStack)item) && (item.func_77973_b() instanceof ItemPickaxe || item.func_77973_b() instanceof ItemSpade);
    }

    public int getCollectArea(ItemStack item) {
        return 1;
    }

    public boolean doCollect(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack tool) {
        NonNullList list = NonNullList.func_191196_a();
        this.getDrops(list, (IBlockAccess)world, pos, state, 0);
        for (ItemStack item : list) {
            double x = player.field_70165_t;
            double y = player.field_70163_u + 0.25;
            double z = player.field_70161_v;
            EntityItem drop = new EntityItem(world, x, y, z, item);
            world.func_72838_d((Entity)drop);
        }
        world.func_175698_g(pos);
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        IClimate clm;
        if (!world.field_72995_K && state != null && state.func_177230_c() != null && !this.onClimateChange(world, pos, state, clm = this.onUpdateClimate(world, pos, state))) {
            BlockSet set = BlockHeatingMetal.getFailureProduct(state);
            if (set != null) {
                IBlockState retS = set.getState();
                world.func_180501_a(pos, retS, 2);
                world.func_175685_c(pos, set.block, true);
                if (this.playSEOnChanging(0)) {
                    world.func_184133_a(null, pos, this.getSE(0), SoundCategory.BLOCKS, 0.8f, 2.0f);
                    DCLogger.debugLog((String)"Heat Treatment Failed");
                }
            }
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + rand.nextInt(21));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int m;
        if (state != null && this.inWater(world, pos) && ((m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16)) == 0 || m == 3 || m == 6 || m == 9 || m == 12)) {
            for (int i = 0; i < 5; ++i) {
                double x = (double)pos.func_177958_n() + rand.nextDouble() * 1.0;
                double y = (double)pos.func_177956_o() + 1.05;
                double z = (double)pos.func_177952_p() + rand.nextDouble() * 1.0;
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, x, y, z, 0.0, 0.05, 0.0, new int[0]);
            }
        }
    }

    boolean inWater(World world, BlockPos pos) {
        if (world != null && pos != null) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (world.func_180495_p(pos.func_177972_a(f)).func_185904_a() != Material.field_151586_h) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockSet getFailureProduct(IBlockState state) {
        int i = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
        switch (i) {
            case 0: 
            case 1: {
                return new BlockSet(MainInit.heatedMetalBlock, 2);
            }
            case 3: 
            case 4: {
                return new BlockSet(MainInit.heatedMetalBlock, 5);
            }
            case 6: 
            case 7: {
                return new BlockSet(MainInit.heatedMetalBlock, 8);
            }
            case 9: 
            case 10: {
                return new BlockSet(MainInit.heatedMetalBlock, 11);
            }
            case 12: 
            case 13: {
                return new BlockSet(MainInit.heatedMetalBlock, 14);
            }
        }
        return null;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta == 0 || meta == 3 || meta == 6 || meta == 9 || meta == 12 ? 10 : 0;
    }
}

