/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.ores;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.main.MainInit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLayerNew
extends DCSimpleBlock
implements ITexturePath {
    private Random rand = new Random();
    private int[] harvestL = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static String[] names = new String[]{"alabaster", "lime", "guano", "niter", "sulfur", "salt", "serpentine", "travertine"};

    public BlockLayerNew(Material m, String s, int max) {
        super(m, s, max, false);
        this.func_149675_a(false);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
    }

    public boolean canClimateUpdate(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public void setHarvestLevel(String toolClass, int level) {
        for (int i = 0; i < 16; ++i) {
            super.setHarvestLevel("pickaxe", 1, this.func_176203_a(i));
        }
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestL[this.func_176201_c(state)];
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table == null || table == DropTable.NONE) {
            return Item.func_150898_a((Block)this);
        }
        return table.dropItem;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        int amo = 1;
        if (table.isFortuneEffective && fortune > 0) {
            int max = MathHelper.func_76143_f((double)(1.0 + (double)fortune * 0.5));
            int d1 = random.nextInt(max);
            return amo + d1;
        }
        return amo;
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(list, world, pos, state, fortune);
        int meta = this.func_176201_c(state);
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        DropTable table = this.getTable(meta);
        int par = 15 + fortune * 5;
        if (rand.nextInt(100) < par && table.secondary != null) {
            list.add((Object)new ItemStack(table.secondary, 1, table.secondaryMeta));
        }
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table == null || table == DropTable.NONE) {
            return meta;
        }
        return table.dropMeta;
    }

    private DropTable getTable(int meta) {
        DropTable[] table = new DropTable[]{DropTable.GYPSUM, DropTable.NONE, DropTable.GUANO, DropTable.NITER, DropTable.SULFUR, DropTable.SALT, DropTable.SERPENTINE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE};
        if (meta < 16) {
            return table[meta];
        }
        return DropTable.NONE;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
        if (meta >= 0) {
            return new ItemStack((Block)this, 1, meta);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public String getTexPath(int meta, boolean f) {
        if (meta >= names.length) {
            meta = names.length - 1;
        }
        String s = "blocks/ores/ore_b_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public static enum DropTable {
        GYPSUM(MainInit.gems_layer, 0, MainInit.gems_layer, 0, true),
        LIME(MainInit.gems_layer, 0, MainInit.gems_layer, 0, false),
        GUANO(MainInit.gems_layer, 6, MainInit.gems_blue, 3, true),
        NITER(MainInit.gems_layer, 2, MainInit.gems_layer, 2, true),
        SULFUR(MainInit.gems_layer, 3, MainInit.gems_layer, 3, true),
        SALT(MainInit.gems_layer, 1, MainInit.gems_layer, 1, true),
        SERPENTINE(MainInit.gems_green, 3, MainInit.gems_green, 1, true),
        NONE(null, 0, null, 0, false);

        public Item dropItem;
        public Item secondary;
        public int dropMeta;
        public int secondaryMeta;
        public boolean isFortuneEffective;

        private DropTable(Item item, int meta, Item sec, int secmeta, boolean f) {
            this.dropItem = item;
            this.secondary = sec;
            this.dropMeta = meta;
            this.secondaryMeta = secmeta;
            this.isFortuneEffective = f;
        }
    }
}

