/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.ores;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.main.MainInit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOreNew
extends DCSimpleBlock
implements ITexturePath {
    private Random rand = new Random();
    private int[] harvestL = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 1};
    private static String[] names = new String[]{"n2_red", "n2_green", "n2_blue", "n2_white", "n2_black", "n1_red", "n1_green", "n1_blue", "n1_white", "n1_black", "n2_red_n", "n1_red_n", "n2_black_n", "n1_black_n", "b_sulfur_n"};

    public BlockOreNew(Material m, String s, int max) {
        super(m, s, max, false);
        this.func_149675_a(false);
        this.func_149711_c(5.0f);
        this.func_149752_b(15.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public void setHarvestLevel(String toolClass, int level) {
        for (int i = 0; i < 16; ++i) {
            if (i < 5) {
                super.setHarvestLevel("pickaxe", 2, this.func_176203_a(i));
                continue;
            }
            super.setHarvestLevel("pickaxe", 3, this.func_176203_a(i));
        }
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestL[this.func_176201_c(state)];
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        return meta;
    }

    private DropTable getTable(int meta) {
        DropTable[] table = new DropTable[]{DropTable.RED, DropTable.GREEN, DropTable.BLUE, DropTable.WHITE, DropTable.BLACK, DropTable.RED_2, DropTable.GREEN_2, DropTable.BLUE_2, DropTable.WHITE_2, DropTable.BLACK_2, DropTable.NETHER_RED_1, DropTable.NETHER_RED_2, DropTable.NETHER_BLACK_1, DropTable.NETHER_BLACK_2, DropTable.NETHER_SULFUR, DropTable.NONE};
        if (meta < 16) {
            return table[meta];
        }
        return DropTable.NONE;
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(list, world, pos, state, fortune);
        int meta = this.func_176201_c(state);
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        DropTable table = this.getTable(meta);
        int par = 5 + fortune * 10;
        if (rand.nextInt(100) < par && table.dropItem != null) {
            list.add((Object)new ItemStack(table.dropItem, 1, table.dropMeta));
        }
        int par2 = 1 + fortune * 5;
        if (rand.nextInt(100) < par2 && table.secondary != null) {
            list.add((Object)new ItemStack(table.secondary, 1, table.secondaryMeta));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
        if (meta >= 0) {
            return new ItemStack((Block)this, 1, meta);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public String getTexPath(int meta, boolean f) {
        if (meta >= names.length) {
            meta = names.length - 1;
        }
        String s = "blocks/ores/ore_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public static enum DropTable {
        RED(MainInit.gems_red, 0, MainInit.gems_red, 1, true),
        GREEN(MainInit.gems_green, 0, MainInit.gems_green, 1, true),
        BLUE(MainInit.gems_blue, 0, MainInit.gems_blue, 1, true),
        WHITE(MainInit.gems_white, 0, MainInit.gems_white, 1, true),
        BLACK(MainInit.gems_black, 0, MainInit.gems_black, 1, true),
        RED_2(MainInit.gems_red, 1, MainInit.gems_red, 2, true),
        GREEN_2(MainInit.gems_green, 1, MainInit.gems_green, 2, true),
        BLUE_2(MainInit.gems_blue, 1, MainInit.gems_blue, 2, true),
        WHITE_2(MainInit.gems_white, 1, MainInit.gems_white, 2, true),
        BLACK_2(MainInit.gems_black, 1, MainInit.gems_black, 2, true),
        NETHER_RED_1(MainInit.gems_red, 0, MainInit.gems_red, 1, true),
        NETHER_RED_2(MainInit.gems_red, 1, MainInit.gems_red, 2, true),
        NETHER_BLACK_1(MainInit.gems_black, 0, MainInit.gems_black, 1, true),
        NETHER_BLACK_2(MainInit.gems_black, 1, MainInit.gems_black, 2, true),
        NETHER_SULFUR(MainInit.gems_layer, 3, Items.field_151137_ax, 0, true),
        NONE(null, 0, null, 0, false);

        public Item dropItem;
        public Item secondary;
        public int dropMeta;
        public int secondaryMeta;
        public boolean isFortuneEffective;

        private DropTable(Item item, int meta, Item sec, int secmeta, boolean f) {
            this.dropItem = item;
            this.secondary = sec;
            this.dropMeta = meta;
            this.secondaryMeta = secmeta;
            this.isFortuneEffective = f;
        }
    }
}

