/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.ores;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.MainInit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOres
extends DCSimpleBlock {
    private Random rand = new Random();
    private int[] harvestL = new int[]{1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3};

    public BlockOres(Material m, String s, int max) {
        super(m, s, max, false);
        this.func_149675_a(false);
        this.func_149711_c(5.0f);
        this.func_149752_b(15.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void setHarvestLevel(String toolClass, int level) {
        for (int i = 0; i < 16; ++i) {
            if (i < 3) {
                super.setHarvestLevel("pickaxe", 1, this.func_176203_a(i));
                continue;
            }
            if (i > 8) {
                super.setHarvestLevel("pickaxe", 3, this.func_176203_a(i));
                continue;
            }
            super.setHarvestLevel("pickaxe", 2, this.func_176203_a(i));
        }
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestL[this.func_176201_c(state)];
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177230_c() != this) {
            return super.func_180660_a(state, rand, fortune);
        }
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table.dropItem == null) {
            return Item.func_150898_a((Block)this);
        }
        return table.dropItem;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        int amo = table.amount;
        if (table.isFortuneEffective && fortune > 0) {
            int max = MathHelper.func_76143_f((double)(1.0 + (double)fortune * 0.5));
            int d1 = random.nextInt(max);
            return table.amount + d1;
        }
        return table.amount;
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table.dropItem == null) {
            return meta;
        }
        return table.dropMeta;
    }

    private DropTable getTable(int meta) {
        DropTable[] table = new DropTable[]{DropTable.GYPSUM, DropTable.HEMATITE, DropTable.CHAL_B, DropTable.SAPPIRE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.CHAL_W, DropTable.CRYSTAL, DropTable.NONE, DropTable.NONE, DropTable.DIAMOND, DropTable.EMERALD, DropTable.NONE};
        if (meta < 16) {
            return table[meta];
        }
        return DropTable.NONE;
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(list, world, pos, state, fortune);
        int meta = this.func_176201_c(state);
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        ItemStack add = ItemStack.field_190927_a;
        int par = 2 + fortune * 5;
        if (rand.nextInt(50) < par) {
            switch (meta) {
                case 0: {
                    add = rand.nextInt(2) == 0 ? new ItemStack(MainInit.gems_black, 1, 5) : new ItemStack(MainInit.gems_white, 1, 5);
                    break;
                }
                case 6: {
                    add = new ItemStack(MainInit.gems_green, 1, 0);
                }
            }
        }
        if (!DCUtil.isEmpty((ItemStack)add)) {
            list.add((Object)add);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
        if (meta >= 0) {
            return new ItemStack((Block)this, 1, meta);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public static enum DropTable {
        GYPSUM(MainInit.gems_layer, 2, 0, true),
        HEMATITE(MainInit.oreDust, 2, 5, true),
        CHAL_B(MainInit.gems_blue, 1, 0, true),
        SAPPIRE(MainInit.gems_blue, 1, 1, true),
        CHAL_W(MainInit.gems_white, 1, 0, true),
        CRYSTAL(Items.field_151128_bU, 1, 0, true),
        DIAMOND(Items.field_151045_i, 1, 0, true),
        EMERALD(Items.field_151166_bC, 1, 0, true),
        NONE(null, 1, 0, false);

        public Item dropItem;
        public int amount;
        public int dropMeta;
        public boolean isFortuneEffective;

        private DropTable(Item item, int amo, int meta, boolean f) {
            this.dropItem = item;
            this.amount = amo;
            this.dropMeta = meta;
            this.isFortuneEffective = f;
        }
    }
}

