/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.ores;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.MainInit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOres2
extends DCSimpleBlock {
    private Random rand = new Random();
    private int[] harvestL = new int[]{1, 1, 2, 2, 2, 3, 2, 2, 2, 2, 1, 3, 0, 0, 0, 0};

    public BlockOres2(Material m, String s, int max) {
        super(m, s, max, false);
        this.func_149675_a(false);
        this.func_149711_c(5.0f);
        this.func_149752_b(15.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void setHarvestLevel(String toolClass, int level) {
        for (int i = 0; i < 16; ++i) {
            if (i == 5 || i == 11) {
                super.setHarvestLevel("pickaxe", 3, this.func_176203_a(i));
                continue;
            }
            if (i < 2 || i == 10) {
                super.setHarvestLevel("pickaxe", 1, this.func_176203_a(i));
                continue;
            }
            if (i == 12) {
                super.setHarvestLevel("pickaxe", 0, this.func_176203_a(i));
                continue;
            }
            super.setHarvestLevel("pickaxe", 2, this.func_176203_a(i));
        }
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestL[this.func_176201_c(state)];
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177230_c() != this) {
            return super.func_180660_a(state, rand, fortune);
        }
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table.dropItem == null) {
            return Item.func_150898_a((Block)this);
        }
        return table.dropItem;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        int amo = table.amount;
        if (table.isFortuneEffective && fortune > 0) {
            int max = MathHelper.func_76143_f((double)(1.0 + (double)fortune * 0.5));
            int d1 = random.nextInt(max);
            return table.amount + d1;
        }
        return table.amount;
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table.dropItem == null) {
            return meta;
        }
        return table.dropMeta;
    }

    private DropTable getTable(int meta) {
        DropTable[] table = new DropTable[]{DropTable.NONE, DropTable.SALT, DropTable.NITER, DropTable.SULFER, DropTable.NONE, DropTable.SCHORL, DropTable.SERPENTINE, DropTable.ALMANDINE, DropTable.NONE, DropTable.NONE, DropTable.BAUXITE, DropTable.RUTILE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE};
        if (meta < 16) {
            return table[meta];
        }
        return DropTable.NONE;
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(list, world, pos, state, fortune);
        int meta = this.func_176201_c(state);
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        Biome biome = world instanceof World ? ((World)world).getBiomeForCoordsBody(pos) : world.func_180494_b(pos);
        ItemStack add = ItemStack.field_190927_a;
        int par = 3 + fortune * 3;
        if (rand.nextInt(100) < par) {
            if (meta == 6) {
                add = new ItemStack(MainInit.gems_green, 1, 2);
            } else if (meta == 7) {
                add = biome.func_76727_i() > 0.8f || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) ? new ItemStack(MainInit.gems_green, 1, 4) : new ItemStack(MainInit.gems_blue, 1, 3);
            } else if (meta == 11) {
                add = new ItemStack(MainInit.gems_red, 1, 3);
            }
        }
        if (!DCUtil.isEmpty((ItemStack)add)) {
            list.add((Object)add);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
        if (meta >= 0) {
            return new ItemStack((Block)this, 1, meta);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public static enum DropTable {
        SALT(MainInit.gems_layer, 1, 1, true),
        NITER(MainInit.gems_layer, 1, 2, true),
        SULFER(MainInit.gems_layer, 1, 3, true),
        SCHORL(MainInit.gems_black, 1, 1, true),
        SERPENTINE(MainInit.gems_layer, 2, 3, true),
        OLIVINE(MainInit.gems_green, 1, 1, true),
        ALMANDINE(MainInit.gems_red, 1, 1, true),
        RUTILE(MainInit.gems_white, 1, 1, true),
        BAUXITE(MainInit.gems_layer, 2, 4, true),
        NONE(null, 1, 0, false);

        public Item dropItem;
        public int amount;
        public int dropMeta;
        public boolean isFortuneEffective;

        private DropTable(Item item, int amo, int meta, boolean f) {
            this.dropItem = item;
            this.amount = amo;
            this.dropMeta = meta;
            this.isFortuneEffective = f;
        }
    }
}

