/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.ores;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.main.MainInit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSkarnOre
extends DCSimpleBlock
implements ITexturePath {
    private Random rand = new Random();
    private int[] harvestL = new int[]{2, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static String[] names = new String[]{"ruby", "aquamarine", "sakura", "iolite", "topaz", "amethyst", "larimar", "fluorite", "quartz"};

    public BlockSkarnOre(String s) {
        super(Material.field_151576_e, s, 8, false);
        this.func_149675_a(false);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
    }

    public boolean canClimateUpdate(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public void setHarvestLevel(String toolClass, int level) {
        for (int i = 0; i < 16; ++i) {
            super.setHarvestLevel("pickaxe", 1, this.func_176203_a(i));
        }
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestL[this.func_176201_c(state)];
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table == null || table == DropTable.NONE) {
            return Item.func_150898_a((Block)this);
        }
        return Item.func_150898_a((Block)table.baseStone.block);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        DropTable table = this.getTable(meta);
        if (table == null || table == DropTable.NONE) {
            return meta;
        }
        return table.baseStone.meta;
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(list, world, pos, state, fortune);
        int meta = this.func_176201_c(state);
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        ItemStack add = ItemStack.field_190927_a;
        DropTable table = this.getTable(meta);
        if (table.dropItem != null) {
            list.add((Object)new ItemStack(table.dropItem, 1, table.dropMeta));
        }
        int par2 = 5 + fortune * 5;
        if (rand.nextInt(100) < par2 && table.secondary != null) {
            list.add((Object)new ItemStack(table.secondary, 1, table.secondaryMeta));
        }
    }

    private DropTable getTable(int meta) {
        DropTable[] table = new DropTable[]{DropTable.RUBY, DropTable.AQUAMARINE, DropTable.SAKURA, DropTable.IOLITE, DropTable.TOPAZ, DropTable.AMETHYST, DropTable.LARIMAR, DropTable.FLUORITE, DropTable.QUARTZ, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE, DropTable.NONE};
        if (meta < 16) {
            return table[meta];
        }
        return DropTable.NONE;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
        if (meta >= 0) {
            return new ItemStack((Block)this, 1, meta);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public String getTexPath(int meta, boolean f) {
        if (meta >= names.length) {
            meta = names.length - 1;
        }
        String s = "blocks/ores/ore_skarn_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public static enum DropTable {
        RUBY(MainInit.gems_red, 5, MainInit.oreItem, 10, true, new BlockSet(MainInit.gemBlock, 6)),
        AQUAMARINE(MainInit.gems_blue, 5, MainInit.gems_red, 2, true, new BlockSet(MainInit.gemBlock, 6)),
        SAKURA(MainInit.gems_white, 3, MainInit.gems_red, 3, true, new BlockSet(MainInit.skarnBlock, 1)),
        IOLITE(MainInit.gems_black, 3, MainInit.gems_black, 5, true, new BlockSet(MainInit.skarnBlock, 1)),
        TOPAZ(MainInit.gems_white, 5, MainInit.gems_white, 5, true, new BlockSet(MainInit.skarnBlock, 2)),
        AMETHYST(MainInit.gems_red, 3, MainInit.gems_black, 4, true, new BlockSet(MainInit.skarnBlock, 2)),
        LARIMAR(MainInit.gems_blue, 4, MainInit.gems_blue, 4, true, new BlockSet(MainInit.skarnBlock, 0)),
        FLUORITE(MainInit.gems_green, 4, MainInit.gems_green, 5, true, new BlockSet(MainInit.skarnBlock, 0)),
        QUARTZ(MainInit.gems_white, 0, Items.field_151128_bU, 0, true, new BlockSet(Blocks.field_150348_b, 0)),
        NONE(null, 0, null, 0, false, new BlockSet(Blocks.field_150348_b, 0));

        public Item dropItem;
        public Item secondary;
        public int dropMeta;
        public int secondaryMeta;
        public boolean isFortuneEffective;
        public BlockSet baseStone;

        private DropTable(Item item, int meta, Item sec, int secmeta, boolean f, BlockSet base) {
            this.dropItem = item;
            this.secondary = sec;
            this.dropMeta = meta;
            this.secondaryMeta = secmeta;
            this.isFortuneEffective = f;
            this.baseStone = base;
        }
    }
}

