/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.client.gui;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.EnumSeason;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.main.block.device.TileStevensonScreen;
import defeatedcrow.hac.main.client.gui.ContainerStevensonScreen;
import defeatedcrow.hac.main.util.DCName;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiStevensonScreen
extends GuiContainer {
    private static final ResourceLocation guiTex = new ResourceLocation("dcs_climate", "textures/gui/stevenson_screen_gui.png");
    private final EntityPlayer player;
    private final TileStevensonScreen tile;
    private IClimate climate;
    private int weather = 0;

    public GuiStevensonScreen(TileStevensonScreen t, EntityPlayer p) {
        super((Container)new ContainerStevensonScreen(t, p));
        this.tile = t;
        this.player = p;
        this.climate = t.getClimate();
        if (t.func_145831_w() != null) {
            boolean dry;
            World world = t.func_145831_w();
            Biome biome = world.getBiomeForCoordsBody(t.func_174877_v());
            boolean snow = biome.func_150559_j() || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && t.func_174877_v().func_177956_o() > 100;
            boolean bl = dry = !biome.func_76738_d() && !biome.func_150559_j();
            if (world.func_72867_j(1.0f) > 0.2f) {
                this.weather = dry ? 5 : (world.func_72819_i(1.0f) > 0.5f ? (snow ? 4 : 3) : (snow ? 2 : 1));
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.tile == null) {
            return;
        }
        int adjX = this.field_146999_f / 2;
        String s = I18n.func_135052_a((String)"dcs.gui.device.stevenson_screen", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, adjX - this.field_146289_q.func_78256_a(s) / 2, 10, 0x404040);
        int date = DCTimeHelper.getDay((World)this.tile.func_145831_w());
        int time = DCTimeHelper.currentTime((World)this.tile.func_145831_w());
        EnumSeason season = DCTimeHelper.getSeasonEnum((World)this.tile.func_145831_w());
        boolean day = DCTimeHelper.isDayTime((World)this.tile.func_145831_w());
        boolean pm = false;
        if (time > 12) {
            time -= 12;
            pm = true;
        }
        int color = day ? 20560 : 0x500050;
        int seasonColor = season.color.func_193350_e();
        this.field_146289_q.func_78276_b(season.name(), adjX - 30 - this.field_146289_q.func_78256_a(season.name()) / 2, 22, seasonColor);
        String s1 = date + " DAY";
        this.field_146289_q.func_78276_b(s1, adjX + 5 - this.field_146289_q.func_78256_a(s1) / 2, 22, 0x404040);
        String s2 = time + (pm ? " PM" : " AM");
        this.field_146289_q.func_78276_b(s2, adjX + 35 - this.field_146289_q.func_78256_a(s1) / 2, 22, color);
        Weather current = Weather.getWeather(this.weather, day);
        String s3 = current.name;
        this.field_146289_q.func_78276_b(s3, adjX - this.field_146289_q.func_78256_a(s3) / 2, 60, 0x404040);
        String s4 = DCName.TEMP2.getLocalizedName();
        this.field_146289_q.func_78276_b(s4, adjX - 25 - this.field_146289_q.func_78256_a(s4) / 2, 80, 0x404040);
        String s5 = DCName.HUM2.getLocalizedName();
        this.field_146289_q.func_78276_b(s5, adjX - 25 - this.field_146289_q.func_78256_a(s5) / 2, 97, 0x404040);
        String s6 = DCName.AIR2.getLocalizedName();
        this.field_146289_q.func_78276_b(s6, adjX - 25 - this.field_146289_q.func_78256_a(s6) / 2, 114, 0x404040);
        if (this.climate != null) {
            DCHeatTier temp = this.climate.getHeat();
            DCHumidity hum = this.climate.getHumidity();
            DCAirflow air = this.climate.getAirflow();
            String s7 = temp.name();
            this.field_146289_q.func_78276_b(s7, adjX + 20 - this.field_146289_q.func_78256_a(s7) / 2, 76, 0x404040);
            String s8 = hum.name();
            this.field_146289_q.func_78276_b(s8, adjX + 20 - this.field_146289_q.func_78256_a(s8) / 2, 93, 0x404040);
            String s9 = air.name();
            this.field_146289_q.func_78276_b(s9, adjX + 20 - this.field_146289_q.func_78256_a(s9) / 2, 110, 0x404040);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiStevensonScreen.guiTex());
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        boolean day = DCTimeHelper.isDayTime((World)this.tile.func_145831_w());
        int x1 = day ? 176 : 200;
        int y1 = this.weather * 18;
        this.func_73729_b(i + 76, j + 40, x1, y1, 24, 18);
        if (this.climate != null) {
            int x2;
            DCHeatTier temp = this.climate.getHeat();
            DCHumidity hum = this.climate.getHumidity();
            DCAirflow air = this.climate.getAirflow();
            if (temp.getID() > 6) {
                x2 = 20 * temp.getID() - 140;
                this.func_73729_b(i + 89, j + 85, x2, 171, 20, 3);
                this.func_73729_b(i + 109, j + 85, x2, 171, 20, 3);
            } else {
                x2 = 20 * temp.getID();
                this.func_73729_b(i + 89, j + 85, x2, 167, 20, 3);
                this.func_73729_b(i + 109, j + 85, x2, 167, 20, 3);
            }
            int x3 = 40 * hum.getID();
            this.func_73729_b(i + 89, j + 102, x3, 175, 40, 3);
            int x4 = 40 * air.getID();
            this.func_73729_b(i + 89, j + 119, x4, 179, 40, 3);
        }
    }

    protected static ResourceLocation guiTex() {
        return guiTex;
    }

    public static enum Weather {
        SUNNY(0, true, "Sunny Day"),
        RAIN(1, true, "Rainfall"),
        SNOW(2, true, "Snowfall"),
        THUNDER(3, true, "Thunderstorm"),
        THUNDERSNOW(4, true, "Thundersnow"),
        CLOUDY(5, true, "Cloudy"),
        LUNA(0, false, "Starry Sky"),
        L_RAIN(1, false, "Rainy Night"),
        L_SNOW(2, false, "Snowy Night"),
        L_THUNDER(3, false, "Thunderstorm Night"),
        L_THUNDERSNOW(4, false, "Thundersnow Night"),
        L_CLOUDY(5, false, "Cloudy Night");

        private final int id;
        private final boolean day;
        private final String name;

        private Weather(int i, boolean d, String n2) {
            this.id = i;
            this.day = d;
            this.name = n2;
        }

        public static Weather getWeather(int i, boolean d) {
            switch (i) {
                case 0: {
                    return d ? SUNNY : LUNA;
                }
                case 1: {
                    return d ? RAIN : L_RAIN;
                }
                case 2: {
                    return d ? SNOW : L_SNOW;
                }
                case 3: {
                    return d ? THUNDER : L_THUNDER;
                }
                case 4: {
                    return d ? THUNDERSNOW : L_THUNDERSNOW;
                }
                case 5: {
                    return d ? CLOUDY : L_CLOUDY;
                }
            }
            return d ? SUNNY : LUNA;
        }
    }
}

