/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.config;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class WorldGenConfig {
    public static final WorldGenConfig INSTANCE = new WorldGenConfig();
    private final String BR = System.getProperty("line.separator");
    public static String[] blocknames = new String[]{"minecraft:dirt:32767", "ModID:sampleBlock:sampleMeta"};
    public static final List<BlockSet> disables = Lists.newArrayList();
    public static int[] depositGen = new int[]{50, 30, 30, 30, 10, 30, 20};
    public static int[] radGen = new int[]{5, 4, 5, 4, 3, 4};
    public static int skarnGen = 30;
    public static int windmillGen = 50;
    public static int saplingGen = 500;
    public static int caravanGen = 20;
    public static int hotspringGen = 100;
    public static boolean mazaiLake = true;
    public static boolean skarnDupeCheck = true;
    public static String geyserGas = "dcs.steam";
    public static Fluid geyserProduct;

    private WorldGenConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Configuration cfg) {
        try {
            int hs;
            int sp;
            int cs;
            int wm;
            int sk;
            int g2;
            int l2;
            int v2;
            int c2;
            int ss2;
            int s2;
            int n;
            int ss;
            int g;
            int l;
            int v;
            int c;
            cfg.load();
            cfg.addCustomCategoryComment("world setting", "This setting is for world gen.");
            cfg.addCustomCategoryComment("ore gen setting", "This setting is for ore gen. " + this.BR + "Please set probability as parsentage." + this.BR + "If you set 0, those ore deposits will not be generated.");
            Property sed_ore = cfg.get("ore gen setting", "Red Vain Gen Probability", depositGen[0], "Generate in High-altitude of mountain. 0-100%");
            Property char_ore = cfg.get("ore gen setting", "Green Vein Gen Probability", depositGen[1], "Generate in underground of mountain. 0-100%");
            Property vein_ore = cfg.get("ore gen setting", "Blue Vein Gen Probability", depositGen[2], "Generate in underground of plane. 0-100%");
            Property lava_ore = cfg.get("ore gen setting", "White Vain Gen Probability", depositGen[3], "Generate in deep-underground. 0-100%");
            Property geode_ore = cfg.get("ore gen setting", "Black Vain Gen Probability", depositGen[4], "Generate in deep-underground. 0-100%");
            Property s_sed_ore = cfg.get("ore gen setting", "Guano Gen Probability", depositGen[5], "Generate under the sea. 0-100%");
            Property neth_ore = cfg.get("ore gen setting", "Nether Vain Gen Probability", depositGen[6], "Generate in the nether. 0-100%");
            Property sed_rad = cfg.get("ore gen setting", "Red Vain Gen Radius", radGen[0], "Default radius: 5");
            Property s_sed_rad = cfg.get("ore gen setting", "Green Vain Gen Radius", radGen[1], "Default radius: 4");
            Property char_rad = cfg.get("ore gen setting", "Blue Vain Gen Radius", radGen[2], "Default radius: 5");
            Property vein_rad = cfg.get("ore gen setting", "White Vein Gen Radius", radGen[3], "Default radius: 4");
            Property lava_rad = cfg.get("ore gen setting", "Black Vain Gen Radius", radGen[4], "Default radius: 3");
            Property geode_rad = cfg.get("ore gen setting", "Geode Gen Radius", radGen[5], "Default radius: 4");
            Property skarn_ore = cfg.get("ore gen setting", "Skarn Gen Probability", skarnGen, "Generate in Forest. 0.00-100.00% (default: 0.3%)");
            Property windmill = cfg.get("world setting", "Windmill Gen Probability", windmillGen, "Generate in Forest or Plain. 0.00-100.00% (default: 0.5%)");
            Property caravan = cfg.get("world setting", "Caravanserai Gen Probability", caravanGen, "Generate in Desert or Savanna. 0.00-100.00% (default: 0.2%)");
            Property mazai = cfg.get("world setting", "Mana Liqueur Lake Gen", mazaiLake, "Enable genaration the mana liqueur lake in nether biome.");
            Property b_gen = cfg.get("ore gen setting", "Blockgen Disable List", blocknames, "Please add block registry names you want exclude from HaC vain generation.");
            Property sap = cfg.get("world setting", "Wild Sapling Gen Probability", saplingGen, "Generate on the surface of Overworld. 0.00-100.00% (default: 5.0%)");
            Property hotspring = cfg.get("world setting", "Hot Spring Gen Probability", hotspringGen, "Generate in Cold Mountains. 0.00-100.00% (default: 1.0%)");
            Property geyser_gas = cfg.get("world setting", "Fumarole Gas Settng", geyserGas, "Set the fluid provided by the fumarole. (It must be gas.)");
            Property skarn_check = cfg.get("world setting", "Skarn Dupe Check", skarnDupeCheck, "Limits skarn generation chunks within a 16x16 chunk partition.");
            int s = sed_ore.getInt();
            if (s < 0 || s > 100) {
                s = 0;
            }
            if ((c = char_ore.getInt()) < 0 || c > 100) {
                c = 0;
            }
            if ((v = vein_ore.getInt()) < 0 || v > 100) {
                v = 0;
            }
            if ((l = lava_ore.getInt()) < 0 || l > 100) {
                l = 0;
            }
            if ((g = geode_ore.getInt()) < 0 || g > 100) {
                g = 0;
            }
            if ((ss = s_sed_ore.getInt()) < 0 || ss > 100) {
                ss = 0;
            }
            if ((n = neth_ore.getInt()) < 0 || n > 100) {
                n = 0;
            }
            if ((s2 = sed_rad.getInt()) < 0 || s2 > 10) {
                s2 = 2;
            }
            if ((ss2 = s_sed_rad.getInt()) < 0 || ss2 > 10) {
                ss2 = 2;
            }
            if ((c2 = char_rad.getInt()) < 0 || c2 > 10) {
                c2 = 2;
            }
            if ((v2 = vein_rad.getInt()) < 0 || v2 > 10) {
                v2 = 2;
            }
            if ((l2 = lava_rad.getInt()) < 0 || l2 > 10) {
                l2 = 2;
            }
            if ((g2 = geode_rad.getInt()) < 0 || g2 > 10) {
                g2 = 2;
            }
            if ((sk = skarn_ore.getInt()) < 0 || sk > 5000) {
                sk = 0;
            }
            if ((wm = windmill.getInt()) < 0 || wm > 5000) {
                wm = 0;
            }
            if ((cs = caravan.getInt()) < 0 || cs > 5000) {
                cs = 0;
            }
            if ((sp = sap.getInt()) < 0 || sp > 5000) {
                sp = 0;
            }
            if ((hs = hotspring.getInt()) < 0 || hs > 5000) {
                hs = 0;
            }
            WorldGenConfig.depositGen[0] = s;
            WorldGenConfig.depositGen[1] = c;
            WorldGenConfig.depositGen[2] = v;
            WorldGenConfig.depositGen[3] = l;
            WorldGenConfig.depositGen[4] = g;
            WorldGenConfig.depositGen[5] = ss;
            WorldGenConfig.depositGen[6] = n;
            WorldGenConfig.radGen[0] = s2;
            WorldGenConfig.radGen[1] = ss2;
            WorldGenConfig.radGen[2] = c2;
            WorldGenConfig.radGen[3] = v2;
            WorldGenConfig.radGen[4] = l2;
            WorldGenConfig.radGen[5] = g2;
            skarnGen = sk;
            windmillGen = wm;
            caravanGen = cs;
            mazaiLake = mazai.getBoolean();
            blocknames = b_gen.getStringList();
            saplingGen = sp;
            hotspringGen = hs;
            geyserGas = geyser_gas.getString();
            skarnDupeCheck = skarn_check.getBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cfg.save();
        }
    }

    public static void loadBlockNames() {
        disables.addAll(MainUtil.getListFromStrings(blocknames, "OreGen Invalid List"));
    }

    public static void loadGeyserGas() {
        Fluid f;
        geyserProduct = MainInit.steam;
        if (geyserGas != null && (f = FluidRegistry.getFluid((String)geyserGas)) != null && f.isGaseous()) {
            geyserProduct = f;
        }
    }
}

