/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityCrowBalloon
extends EntityLivingBase {
    public float swing = 0.0f;
    public float swingPrev = 0.0f;
    private final NonNullList<ItemStack> handItems;
    private final NonNullList<ItemStack> armorItems;

    public EntityCrowBalloon(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 2.0f);
        this.handItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        this.armorItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.func_70606_j(30.0f);
    }

    public EntityCrowBalloon(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public EntityCrowBalloon(World worldIn, double posX, double posY, double posZ, float yaw) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
        this.field_70177_z = yaw;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.armorItems) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(nbttagcompound);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("ArmorItems", (NBTBase)nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemstack1 : this.handItems) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_77955_b(nbttagcompound1);
            }
            nbttaglist1.func_74742_a((NBTBase)nbttagcompound1);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ArmorItems", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)new ItemStack(nbttaglist.func_150305_b(i)));
            }
        }
        if (compound.func_150297_b("HandItems", 9)) {
            NBTTagList nbttaglist1 = compound.func_150295_c("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, (Object)new ItemStack(nbttaglist1.func_150305_b(j)));
            }
        }
    }

    public Iterable<ItemStack> func_184214_aD() {
        return this.handItems;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return this.armorItems;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return (ItemStack)this.handItems.get(slotIn.func_188454_b());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(slotIn.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(stack);
                this.handItems.set(slotIn.func_188454_b(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(stack);
                this.armorItems.set(slotIn.func_188454_b(), (Object)stack);
            }
        }
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    private void dropContents() {
        this.playBrokenSound();
        for (int i = 0; i < this.handItems.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.handItems.get(i);
            if (itemstack.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this).func_177984_a(), (ItemStack)itemstack);
            this.handItems.set(i, (Object)ItemStack.field_190927_a);
        }
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)this.armorItems.get(j);
            if (itemstack1.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this).func_177984_a(), (ItemStack)itemstack1);
            this.armorItems.set(j, (Object)ItemStack.field_190927_a);
        }
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187619_bk, this.func_184176_by(), 1.0f, 1.0f);
    }

    private void playDamageSound() {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187707_l, this.func_184176_by(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 1.5, this.field_70161_v, 10, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150357_h.func_176223_P())});
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!((double)this.func_70032_d(entity) <= 0.2)) continue;
            entity.func_70108_f((Entity)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) return false;
        if (DamageSource.field_76380_i.equals(source)) {
            this.func_70106_y();
            return false;
        }
        if (DamageSource.field_76368_d.equals(source)) {
            this.playBrokenSound();
            this.func_70106_y();
            return false;
        }
        if (this.func_180431_b(source)) return false;
        if (!(source instanceof EntityDamageSource)) return false;
        if (source.func_76346_g() instanceof EntityPlayer) {
            this.dropContents();
            this.func_70106_y();
            return false;
        }
        float count = this.func_110143_aJ();
        if (count <= 1.0f) {
            this.dropContents();
            this.func_70106_y();
            return false;
        }
        this.func_70606_j(count - 1.0f);
        this.playDamageSound();
        this.playParticles();
        return false;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            this.swingPrev = this.swing;
            this.swing += 4.0f;
            if (this.swing > 360.0f) {
                this.swing -= 360.0f;
                this.swingPrev -= 360.0f;
            }
        }
        if (this.func_70055_a(Material.field_151586_h)) {
            this.field_70181_x = 0.05;
        }
        AxisAlignedBB aabb = this.func_174813_aQ().func_72314_b(8.0, 1.0, 8.0);
        List list = this.field_70170_p.func_72839_b((Entity)this, aabb);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityLiving) || !(entity instanceof IMob)) continue;
            EntityLiving liv = (EntityLiving)entity;
            EntityLivingBase target = liv.func_70638_az();
            liv.func_70624_b((EntityLivingBase)this);
        }
    }
}

