/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.entity;

import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.main.entity.EntityBulletDC;
import net.minecraft.block.BlockFire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityExtinctionBullet
extends EntityBulletDC {
    public EntityExtinctionBullet(World worldIn) {
        super(worldIn);
    }

    public EntityExtinctionBullet(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityExtinctionBullet(World worldIn, EntityLivingBase shooter) {
        super(worldIn, (Entity)shooter);
    }

    @Override
    protected void onHit(RayTraceResult trace) {
        Entity entity = trace.field_72308_g;
        if (entity != null) {
            BlockPos pos = entity.func_180425_c();
            this.onEffect(pos.func_177984_a());
        }
    }

    @Override
    protected void onHitBlock(RayTraceResult trace) {
        if (trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = trace.func_178782_a();
            EnumFacing side = trace.field_178784_b;
            if (side != null) {
                pos.func_177972_a(side);
            }
            this.onEffect(pos);
        }
    }

    private void onEffect(BlockPos pos) {
        int r = 8;
        for (int x = -r; x < r; ++x) {
            for (int y = -r; y < r; ++y) {
                for (int z = -r; z < r; ++z) {
                    BlockPos p = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    IBlockState state = this.field_70170_p.func_180495_p(p);
                    if (!(state.func_177230_c() instanceof BlockFire) && state.func_177230_c() != MagicInit.infernalFlame) continue;
                    this.field_70170_p.func_175698_g(p);
                }
            }
        }
    }

    @Override
    public boolean getIsPenetrate() {
        return true;
    }

    @Override
    public double getGravity() {
        return 0.01;
    }

    @Override
    public EntityBulletDC.BulletType getBulletType() {
        return EntityBulletDC.BulletType.BULLET;
    }
}

