/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.entity;

import defeatedcrow.hac.core.util.DCUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class EntityProjBase
extends EntityArrow
implements IProjectile {
    private int age = 0;
    private int count = 0;
    private boolean start = false;

    public EntityProjBase(World worldIn) {
        super(worldIn);
        this.setStart(false);
    }

    public EntityProjBase(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityProjBase(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
        this.field_70250_c = shooter;
    }

    public void setStart(boolean i) {
        this.start = i;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        if (!this.field_70170_p.field_72995_K) {
            if (this.start) {
                if (this.count > 0) {
                    if (this.onGroundHit()) {
                        // empty if block
                    }
                } else {
                    ++this.count;
                }
            } else if (this.field_70254_i) {
                this.setStart(true);
            } else if (this.field_70171_ac) {
                this.setStart(true);
            }
        } else if (this.field_70254_i) {
            this.onGroundClient();
        } else {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y + this.field_70181_x * this.field_70181_x < 0.005 && this.age > 3000) {
            this.func_70106_y();
        }
    }

    protected void onGroundClient() {
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        if (this.age < 1) {
            return;
        }
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null && !this.field_70170_p.field_72995_K) {
            if (entity.func_70028_i(this.field_70250_c) || entity instanceof IProjectile) {
                return;
            }
            if (this.onEntityHit(entity)) {
                return;
            }
            float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            float damage = this.getHitDamage(entity, speed);
            DamageSource source = this.getHitSource(entity);
            if (source != null && damage > 0.0f && entity.func_70097_a(source, damage)) {
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase living = (EntityLivingBase)entity;
                    if (this.field_70250_c != null && living != this.field_70250_c && living instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!this.canPenetrate()) {
                    this.func_70106_y();
                }
            } else {
                this.dropAndDeath();
            }
        } else {
            super.func_184549_a(raytraceResultIn);
        }
    }

    protected boolean onGroundHit() {
        return false;
    }

    protected boolean onEntityHit(Entity entity) {
        return false;
    }

    protected float getHitDamage(Entity target, float speed) {
        return 0.0f;
    }

    protected DamageSource getHitSource(Entity target) {
        return null;
    }

    protected boolean canPenetrate() {
        return false;
    }

    public abstract ItemStack getDropStack();

    protected void dropAndDeath() {
        this.dropAsItem();
        this.func_70106_y();
    }

    protected void dropAsItem() {
        ItemStack item;
        if (!this.field_70170_p.field_72995_K && !DCUtil.isEmpty((ItemStack)(item = this.getDropStack()))) {
            EntityItem drop = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.15, this.field_70161_v, item);
            drop.field_70181_x = 0.025;
            this.field_70170_p.func_72838_d((Entity)drop);
        }
    }

    public boolean func_70241_g() {
        return false;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("HitStart")) {
            this.start = compound.func_74767_n("HitStart");
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("HitStart", this.start);
    }
}

