/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.event;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.block.build.BlockBedDC;
import defeatedcrow.hac.main.client.particle.ParticleTempColor;
import defeatedcrow.hac.main.config.MainCoreConfig;
import defeatedcrow.hac.main.util.DCAdvancementUtil;
import defeatedcrow.hac.main.util.DCArmorMaterial;
import defeatedcrow.hac.main.util.MainUtil;
import defeatedcrow.hac.main.util.portal.DCDimChangeHelper;
import defeatedcrow.hac.main.worldgen.CaravanGenEvent;
import defeatedcrow.hac.main.worldgen.CaravanGenPos;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LivingMainEventDC {
    private int count = 0;
    private boolean x_key = false;

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof IMob) {
            int num;
            int cx = (int)event.getX() >> 4;
            int cz = (int)event.getZ() >> 4;
            if (event.getY() > 65.0f && event.getY() < 120.0f && (num = CaravanGenPos.getCaravanPartNum(cx, cz, living.func_130014_f_())) > -1) {
                int nx = num % 3 - 1;
                int nz = num / 3 - 1;
                int cx2 = cx + nx;
                int cz2 = cz + nz;
                int height = CaravanGenPos.getCoreHeight(cx2, cz2, event.getWorld());
                int px = cx << 4;
                int pz = cz << 4;
                int py = height;
                BlockPos p1 = new BlockPos(px + 7, height - 7, pz + 7);
                if (event.getWorld().func_175667_e(p1) && CaravanGenPos.getType(event.getWorld(), p1) != CaravanGenEvent.CaravanType.BROKEN) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living != null && living instanceof EntityPlayer) {
            this.onPlayerUpdate(event);
            if (living.field_70170_p.field_72995_K) {
                this.onPlayerKeyUpdate(event);
                this.onPlayerToolClientUpdate(event);
            }
        } else if (living instanceof IMob) {
            this.onEnemyUpdate(event);
        }
        this.onLivingUpdate(event);
    }

    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && !entity.func_184218_aH() && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.func_70644_a(MainInit.ocean) && player.func_70090_H()) {
                player.func_70050_g(300);
            }
            if (player.func_70644_a(MainInit.bird)) {
                player.field_70143_R = 0.0f;
            }
            if (player.func_70644_a(MainInit.warp) && !player.func_184218_aH() && player.field_70123_F) {
                DCLogger.debugInfoLog((String)"check");
                EnumFacing face = player.func_174811_aO();
                BlockPos pos = player.func_180425_c().func_177967_a(face, 2);
                if (this.isAir(player.field_70170_p, pos) && this.isAir(player.field_70170_p, pos.func_177984_a())) {
                    if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                    } else {
                        player.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                    }
                    player.field_70143_R = 0.0f;
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 2.0f);
                }
            }
            if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
                boolean b1 = false;
                boolean b2 = false;
                for (ItemStack armor : player.field_71071_by.field_70460_b) {
                    if (DCUtil.isEmpty((ItemStack)armor) || !(armor.func_77973_b() instanceof ItemArmor)) continue;
                    if (((ItemArmor)armor.func_77973_b()).func_82812_d() == DCArmorMaterial.DC_LINEN || ((ItemArmor)armor.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER) {
                        b1 = true;
                        continue;
                    }
                    if (((ItemArmor)armor.func_77973_b()).func_82812_d() != DCArmorMaterial.DC_CLOTH && ((ItemArmor)armor.func_77973_b()).func_82812_d() != DCArmorMaterial.DC_SYNTHETIC) continue;
                    b2 = true;
                }
                if (b1) {
                    DCAdvancementUtil.unlock(player, "climate_wear");
                }
                if (b2) {
                    DCAdvancementUtil.unlock(player, "climate_wear2");
                }
                if (DCDimChangeHelper.inWarpProcess(player)) {
                    DCDimChangeHelper.warp(player);
                }
            }
        }
    }

    boolean isAir(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        return world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) == null;
    }

    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && !entity.field_70170_p.field_72995_K && entity.func_70644_a(MainInit.gravity) && entity.func_70090_H() && !entity.field_70122_E) {
            entity.field_70181_x -= 0.25;
        }
    }

    public void onEnemyUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && entity.func_70089_S() && !entity.field_70170_p.field_72995_K) {
            List players = entity.field_70170_p.field_73010_i;
            boolean flag = false;
            for (EntityPlayer p : players) {
                double d1;
                double dist;
                if (!p.func_70089_S() || !((dist = Math.sqrt(d1 = p.func_180425_c().func_177951_i((Vec3i)entity.func_180425_c()))) < 32.0) || !MainUtil.isHeldItem(MainInit.entityScope, (EntityLivingBase)p) && !p.func_70644_a(MainInit.clairvoyance)) continue;
                flag = true;
            }
            if (flag) {
                int i = 0;
                if (entity.func_70644_a(MobEffects.field_188423_x)) {
                    PotionEffect eff = entity.func_70660_b(MobEffects.field_188423_x);
                    i = eff.func_76459_b();
                }
                if (i < 10) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 60, 0));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerKeyUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && entity instanceof EntityPlayer && !(player = (EntityPlayer)event.getEntity()).func_184218_aH()) {
            if (MainCoreConfig.ocean_effect && player.func_70644_a(MainInit.ocean) && player.func_70090_H()) {
                if (ClimateCore.proxy.isJumpKeyDown()) {
                    player.field_70181_x += 0.15;
                    if (player.field_70181_x > 2.0) {
                        player.field_70181_x = 2.0;
                    }
                } else if (ClimateMain.proxy.isSneakKeyDown() && !player.field_70122_E) {
                    player.field_70181_x -= 0.15;
                    if (player.field_70181_x < -2.0) {
                        player.field_70181_x = -2.0;
                    }
                }
            } else if (MainCoreConfig.bird_effect && player.func_70644_a(MainInit.bird) && !player.func_70090_H() && !player.func_184613_cA()) {
                if (ClimateCore.proxy.isJumpKeyDown()) {
                    player.field_70181_x += 0.15;
                    if (player.field_70181_x > 2.0) {
                        player.field_70181_x = 2.0;
                    }
                } else if (ClimateMain.proxy.isSneakKeyDown() && !player.field_70122_E) {
                    player.field_70181_x = 0.0;
                }
                if (ClimateMain.proxy.isForwardKeyDown() && !player.field_70122_E) {
                    Vec3d vec3d = player.func_70040_Z();
                    double d = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y);
                    double d1 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
                    double df = 1.0;
                    if (player.func_70644_a(MobEffects.field_76424_c)) {
                        df += (double)player.func_70660_b(MobEffects.field_76424_c).func_76458_c() * 0.5;
                    }
                    if (d < df) {
                        player.field_70159_w += vec3d.field_72450_a * 0.05 * df;
                        player.field_70179_y += vec3d.field_72449_c * 0.05 * df;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerToolClientUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            World world = player.field_70170_p;
            if (!DCUtil.isEmpty((ItemStack)player.func_184614_ca()) && player.func_184614_ca().func_77973_b() == MainInit.scope || !DCUtil.isEmpty((ItemStack)player.func_184592_cb()) && player.func_184592_cb().func_77973_b() == MainInit.scope) {
                EnumFacing face = player.func_174811_aO();
                BlockPos pos = player.func_180425_c().func_177967_a(face, 2);
                BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
                for (int x1 = -8; x1 < 8; ++x1) {
                    for (int z1 = -8; z1 < 8; ++z1) {
                        for (int y1 = -3; y1 < 3; ++y1) {
                            DCHeatTier heat;
                            mpos.func_181079_c(pos.func_177958_n() + x1, pos.func_177956_o() + y1, pos.func_177952_p() + z1);
                            IBlockState state = world.func_180495_p((BlockPos)mpos);
                            IBlockState s2 = world.func_180495_p(mpos.func_177984_a());
                            if (s2.func_177230_c().isNormalCube(s2, (IBlockAccess)world, mpos.func_177984_a()) || (heat = ClimateAPI.calculator.getBlockHeatTier(world, mpos.func_177984_a(), (BlockPos)mpos)) == null || heat == DCHeatTier.NORMAL) continue;
                            double px = (double)mpos.func_177958_n() + 0.5;
                            double py = (double)mpos.func_177956_o() + 0.5;
                            double pz = (double)mpos.func_177952_p() + 0.5;
                            Particle shock = new ParticleTempColor.Factory().func_178902_a(0, world, px, py, pz, 0.0, 0.0, 0.0, heat.getColor());
                            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(shock);
                        }
                    }
                }
            }
        }
    }

    public void trySleep(PlayerSleepInBedEvent event) {
        IBlockState state;
        if (event.getEntityPlayer() != null && event.getEntityPlayer().func_130014_f_().func_175667_e(event.getPos()) && (state = event.getEntityPlayer().func_130014_f_().func_180495_p(event.getPos())).func_177230_c() instanceof BlockBedDC) {
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            if (!event.getEntityPlayer().func_130014_f_().field_72995_K) {
                if (event.getEntityPlayer().func_70608_bn() || !event.getEntityPlayer().func_70089_S()) {
                    event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                    return;
                }
                double d2 = 8.0;
                double d1 = 5.0;
                List list = event.getEntityPlayer().func_130014_f_().func_175647_a(EntityMob.class, new AxisAlignedBB((double)event.getPos().func_177958_n() - d1, (double)event.getPos().func_177956_o() - d2, (double)event.getPos().func_177952_p() - d1, (double)event.getPos().func_177958_n() + d1, (double)event.getPos().func_177956_o() + d2, (double)event.getPos().func_177952_p() + d1), null);
                if (!list.isEmpty()) {
                    event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
                }
            }
            if (event.getEntityPlayer().func_184218_aH()) {
                event.getEntityPlayer().func_184210_p();
            }
            if (face != null) {
                float f1 = 0.5f + (float)face.func_82601_c() * 0.4f;
                float f = 0.5f + (float)face.func_82599_e() * 0.4f;
                event.getEntityPlayer().field_71079_bU = -1.8f * (float)face.func_82601_c();
                event.getEntityPlayer().field_71089_bV = -1.8f * (float)face.func_82599_e();
                event.getEntityPlayer().func_70107_b((double)((float)event.getPos().func_177958_n() + f1), (double)((float)event.getPos().func_177956_o() + 0.6875f), (double)((float)event.getPos().func_177952_p() + f));
            } else {
                event.getEntityPlayer().func_70107_b((double)((float)event.getPos().func_177958_n() + 0.5f), (double)((float)event.getPos().func_177956_o() + 0.6875f), (double)((float)event.getPos().func_177952_p() + 0.5f));
            }
            try {
                Field f1 = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"sleeping"});
                f1.setAccessible(true);
                f1.set(event.getEntityPlayer(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            event.getEntityPlayer().field_71081_bT = event.getPos();
            event.getEntityPlayer().field_70159_w = 0.0;
            event.getEntityPlayer().field_70181_x = 0.0;
            event.getEntityPlayer().field_70179_y = 0.0;
            if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
                event.getEntityPlayer().field_70170_p.func_72854_c();
            }
            event.setResult(EntityPlayer.SleepResult.OK);
            event.getEntityPlayer().getEntityData().func_74757_a("doSleep", true);
        }
    }

    public void inBed(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K && event.player.getEntityData().func_74767_n("doSleep")) {
            ReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)event.player, (Object)false, (String[])new String[]{"sleeping"});
        }
    }

    public void inBed2(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && event.player.getEntityData().func_74767_n("doSleep")) {
            ReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)event.player, (Object)true, (String[])new String[]{"sleeping"});
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerSetSpawnEvent event) {
        IBlockState state;
        if (event.getEntityPlayer() != null && event.getNewSpawn() != null && (state = event.getEntityPlayer().func_130014_f_().func_180495_p(event.getNewSpawn())) != null && state.func_177230_c() instanceof BlockBedDC) {
            event.setCanceled(true);
        }
    }

    public void onWakeUp2(PlayerWakeUpEvent event) {
        event.getEntityLiving().getEntityData().func_82580_o("doSleep");
    }
}

