/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.event;

import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.util.MainUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OnDeathEventDC {
    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (living == null) {
            return;
        }
        boolean flag = false;
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            boolean hasCharm = false;
            ItemStack charm = ItemStack.field_190927_a;
            if (ModuleConfig.magic) {
                charm = MainUtil.getCharmItem((EntityLivingBase)player, new ItemStack(MagicInit.colorBadge, 1, 1));
            }
            if (!DCUtil.isEmpty((ItemStack)charm)) {
                NBTTagCompound tag;
                int dim = player.field_70170_p.field_73011_w.getDimension();
                BlockPos pos = player.getBedLocation(dim);
                if (pos == null && (tag = charm.func_77978_p()) != null && tag.func_74764_b("dcs.portal.dim")) {
                    String warpDim = tag.func_74779_i("dcs.portal.dimname");
                    int x = tag.func_74762_e("dcs.portal.x");
                    int y = tag.func_74762_e("dcs.portal.y");
                    int z = tag.func_74762_e("dcs.portal.z");
                    if (dim == tag.func_74762_e("dcs.portal.dim")) {
                        pos = new BlockPos(x, y, z);
                    }
                }
                if (pos != null) {
                    player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
                }
                player.field_70143_R = 0.0f;
                player.func_70606_j(6.0f + (float)charm.func_190916_E() * 5.0f);
                event.setCanceled(true);
                flag = true;
            }
            if (!flag && player.getDisplayNameString().equals("defeatedcrow")) {
                DCLogger.infoLog((String)"defeatedcrow dies...");
                ItemStack chicken = new ItemStack(FoodInit.sticks, 1, 3);
                EntityItem drop = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, chicken);
                player.field_70170_p.func_72838_d((Entity)drop);
            }
        }
    }

    @SubscribeEvent
    public void onDrop(LivingHurtEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        DamageSource source = event.getSource();
        float dam = event.getAmount();
        if (living == null) {
            return;
        }
        if (!(living instanceof EntityPlayer) && dam >= living.func_110143_aJ() && DCUtil.hasCharmItem((EntityLivingBase)living, (ItemStack)new ItemStack(MagicInit.colorBadge, 1, 1))) {
            living.field_70143_R = 0.0f;
            living.func_70606_j(living.func_110138_aP() * 0.5f);
            living.field_70170_p.func_184133_a(null, living.func_180425_c(), SoundEvents.field_187571_bR, SoundCategory.PLAYERS, 1.0f, 0.75f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDropLoot(LivingDropsEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        DamageSource source = event.getSource();
        int level = event.getLootingLevel();
        if (living == null) {
            return;
        }
        if (ModuleConfig.food && !living.field_70170_p.field_72995_K && living.field_70170_p.field_73012_v.nextInt(3) == 0) {
            if (living instanceof EntitySquid) {
                if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
                    ItemStack squid = new ItemStack(FoodInit.meat, 1, 2);
                    EntityItem drop = new EntityItem(living.field_70170_p, living.field_70165_t, living.field_70163_u, living.field_70161_v, squid);
                    event.getDrops().add(drop);
                }
            } else if (living instanceof EntityAnimal && source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
                ItemStack vis = new ItemStack(FoodInit.meat, 1, 0);
                EntityItem drop = new EntityItem(living.field_70170_p, living.field_70165_t, living.field_70163_u, living.field_70161_v, vis);
                event.getDrops().add(drop);
            }
        }
    }
}

