/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.event;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.cultivate.IClimateCrop;
import defeatedcrow.hac.api.magic.CharmType;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.config.CoreConfigDC;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.magic.event.MagicCommonEvent;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.IWideMining;
import defeatedcrow.hac.main.block.device.BlockFirestand;
import defeatedcrow.hac.main.item.tool.ItemScytheDC;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OnMiningEventDC {
    private final Random rand = new Random();

    @SubscribeEvent
    public void preMining(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer() != null) {
            if (DCUtil.hasCharmItem((EntityLivingBase)event.getEntityPlayer(), (ItemStack)new ItemStack(MagicInit.colorPendant, 1, 2))) {
                float lv = 2.0f + (float)MainUtil.getCharmLevel((EntityLivingBase)event.getEntityPlayer(), new ItemStack(MagicInit.colorPendant, 1, 2));
                event.setNewSpeed(event.getNewSpeed() * lv);
            } else if (event.getEntityPlayer().func_70055_a(Material.field_151586_h)) {
                float lv = 1.0f;
                if (event.getEntityPlayer().func_70660_b(MainInit.ocean) != null) {
                    lv += (float)event.getEntityPlayer().func_70660_b(MainInit.ocean).func_76458_c() * 1.0f;
                }
                int c = MainUtil.getCharmLevel((EntityLivingBase)event.getEntityPlayer(), new ItemStack(MagicInit.colorPendant2, 1, 0));
                event.setNewSpeed(event.getNewSpeed() * (lv += (float)c * 1.0f));
            }
        }
    }

    @SubscribeEvent
    public void onMining(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && !event.getWorld().field_72995_K) {
            IBlockState state = event.getState();
            ItemStack held = event.getHarvester().func_184614_ca();
            int level = event.getFortuneLevel() + 1;
            if (state == null || DCUtil.isEmpty((ItemStack)held)) {
                return;
            }
            float f = event.getWorld().field_73012_v.nextFloat();
            if (state.func_177230_c() instanceof BlockBush && (held.func_77973_b() instanceof ItemShears || held.func_77973_b() instanceof ItemSword) && f < 0.1f * (float)level) {
                event.getDrops().add(new ItemStack(FoodInit.crops, 1, 9));
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && !event.getWorld().field_72995_K) {
            NonNullList charms;
            IBlockState state = event.getState();
            ItemStack held = event.getPlayer().func_184614_ca();
            BlockPos pos = event.getPos();
            int range = 0;
            if (held.func_77973_b() instanceof IWideMining) {
                range += ((IWideMining)held.func_77973_b()).getMiningRange(event.getPlayer(), held, 0);
            }
            if (!event.getPlayer().func_70651_bq().isEmpty()) {
                for (Iterator eff : event.getPlayer().func_70651_bq()) {
                    if (!(eff.func_188419_a() instanceof IWideMining)) continue;
                    range += ((IWideMining)eff.func_188419_a()).getMiningRange(event.getPlayer(), held, eff.func_76458_c());
                }
            }
            if (!(charms = DCUtil.getPlayerCharm((EntityPlayer)event.getPlayer(), (CharmType)CharmType.CONSTANT)).isEmpty()) {
                for (ItemStack check : charms) {
                    if (!(check.func_77973_b() instanceof IWideMining)) continue;
                    range += ((IWideMining)check.func_77973_b()).getMiningRange(event.getPlayer(), check, 0);
                }
            }
            if (range > 0) {
                RayTraceResult ret = this.rayTrace(event.getWorld(), event.getPlayer());
                if (ret != null && ret.field_72313_a == RayTraceResult.Type.BLOCK) {
                    EnumFacing face = ret.field_178784_b;
                    List<BlockPos> list = this.getTargetPos(pos, face, range);
                    for (BlockPos p : list) {
                        IBlockState block;
                        if (!event.getPlayer().func_175151_a(p, face, held) || !(block = event.getWorld().func_180495_p(p)).func_177230_c().canHarvestBlock((IBlockAccess)event.getWorld(), p, event.getPlayer()) || block.func_177230_c().hasTileEntity(block) || !(block.func_185887_b(event.getWorld(), p) >= 0.0f)) continue;
                        block.func_177230_c().func_180657_a(event.getWorld(), event.getPlayer(), p, block, null, held);
                        event.getWorld().func_175698_g(p);
                    }
                }
                if (!event.getPlayer().field_71075_bZ.field_75098_d && (event.getWorld().func_175659_aa() != EnumDifficulty.PEACEFUL || CoreConfigDC.peacefulDam)) {
                    event.getPlayer().func_71020_j(0.1f);
                }
            }
        }
    }

    List<BlockPos> getTargetPos(BlockPos pos, EnumFacing face, int r) {
        ArrayList ret = Lists.newArrayList();
        if (face.func_176740_k() == EnumFacing.Axis.X) {
            for (int z = -r; z <= r; ++z) {
                for (int y = -r; y <= r; ++y) {
                    if (z == 0 && y == 0) continue;
                    BlockPos p = pos.func_177982_a(0, y, z);
                    ret.add(p);
                }
            }
            return ret;
        }
        if (face.func_176740_k() == EnumFacing.Axis.Z) {
            for (int x = -r; x <= r; ++x) {
                for (int y = -r; y <= r; ++y) {
                    if (x == 0 && y == 0) continue;
                    BlockPos p = pos.func_177982_a(x, y, 0);
                    ret.add(p);
                }
            }
            return ret;
        }
        for (int z = -r; z <= r; ++z) {
            for (int x = -r; x <= r; ++x) {
                if (z == 0 && x == 0) continue;
                BlockPos p = pos.func_177982_a(x, 0, z);
                ret.add(p);
            }
        }
        return ret;
    }

    protected RayTraceResult rayTrace(World world, EntityPlayer player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return world.func_147447_a(vec3d, vec3d1, false, true, false);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        ItemStack stack = event.getItemStack();
        if (player != null && !DCUtil.isEmpty((ItemStack)stack)) {
            if (stack.func_77973_b() instanceof ItemScytheDC) {
                if (MagicCommonEvent.getOffhandJewelColor((EntityLivingBase)player) == MagicColor.BLUE) {
                    return;
                }
                if (!player.field_70170_p.field_72995_K) {
                    boolean b = false;
                    int area = ((ItemScytheDC)stack.func_77973_b()).range;
                    for (int x = -area; x <= area; ++x) {
                        for (int z = -area; z <= area; ++z) {
                            for (int y = -area; y <= area; ++y) {
                                BlockPos p1 = pos.func_177982_a(x, y, z);
                                IBlockState target = player.field_70170_p.func_180495_p(p1);
                                if (!(target.func_177230_c() instanceof IClimateCrop)) continue;
                                ((IClimateCrop)target.func_177230_c()).harvest(player.field_70170_p, p1, target, player);
                                b = true;
                            }
                        }
                    }
                    if (b) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        event.setUseBlock(Event.Result.ALLOW);
                    }
                }
                player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187763_eJ, SoundCategory.PLAYERS, 1.5f, 1.5f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + 0.5f);
            } else if (player.func_70093_af() && stack.func_77973_b() instanceof ItemPickaxe) {
                ItemPickaxe pic = (ItemPickaxe)stack.func_77973_b();
                IBlockState state = event.getWorld().func_180495_p(pos);
                if (pos.func_177956_o() > 0 && pic.getHarvestLevel(stack, "pickaxe", player, state) >= 4 && state != null && state.func_177230_c() == Blocks.field_150357_h && player.func_175151_a(pos, EnumFacing.UP, stack)) {
                    ItemStack item = new ItemStack(Blocks.field_150357_h);
                    EntityItem drop = new EntityItem(event.getWorld(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, item);
                    if (!event.getWorld().field_72995_K) {
                        event.getWorld().func_175698_g(pos);
                        event.getWorld().func_72838_d((Entity)drop);
                        stack.func_77972_a(1, event.getEntityLiving());
                        event.setUseBlock(Event.Result.ALLOW);
                    }
                    player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187835_fT, SoundCategory.PLAYERS, 1.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + 0.5f);
                }
            }
        }
    }

    @SubscribeEvent
    public void canCreateSource(BlockEvent.CreateFluidSourceEvent event) {
        IBlockState fluid = event.getWorld().func_180495_p(event.getPos());
        if (fluid.func_177230_c() == MainInit.hotSpringBlock) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onFirePlace(BlockEvent.PlaceEvent event) {
        IBlockState placed = event.getPlacedBlock();
        IBlockState against = event.getPlacedAgainst();
        if (placed.func_177230_c() == Blocks.field_150480_ab && against.func_177230_c() == MainInit.firestand) {
            if (!event.getWorld().field_72995_K) {
                BlockPos p = null;
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    if (event.getWorld().func_180495_p(event.getPos().func_177972_a(f)).func_177230_c() != MainInit.firestand) continue;
                    p = event.getPos().func_177972_a(f);
                }
                if (p != null) {
                    BlockFirestand.changeLitState(event.getWorld(), p, true);
                }
                event.getPlayer().func_184185_a(SoundEvents.field_187649_bu, 0.8f, 1.0f);
            }
            event.setCanceled(true);
        }
    }
}

