/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.item.equip;

import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.client.base.ModelThinBiped;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.api.IColorableArmor;
import defeatedcrow.hac.main.config.MainCoreConfig;
import defeatedcrow.hac.main.util.DCMaterialEnum;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.DyeUtils;

public class ItemArmorDC
extends ItemArmor
implements ITexturePath,
IColorableArmor {
    public final String tex;
    public final DCMaterialEnum field_77878_bZ;
    public static final String PASS = "dcs_climate:textures/models/armor/";
    public EnumDyeColor[] colorList = new EnumDyeColor[0];

    public ItemArmorDC(ItemArmor.ArmorMaterial m, DCMaterialEnum mat, EntityEquipmentSlot slot, String t) {
        super(m, 2, slot);
        this.field_77878_bZ = mat;
        this.tex = t;
    }

    public ItemArmorDC setColorList(EnumDyeColor ... list) {
        if (list != null) {
            this.colorList = list;
        }
        return this;
    }

    @Override
    public void setColorableList(EnumDyeColor ... colors) {
        if (colors != null) {
            this.colorList = colors;
        }
    }

    public String getTexPath(int meta, boolean isFull) {
        String s = "met_";
        switch (this.field_77881_a) {
            case CHEST: {
                s = "plate_";
                break;
            }
            case LEGS: {
                s = "leggins_";
                break;
            }
            case FEET: {
                s = "boots_";
                break;
            }
            default: {
                s = "met_";
            }
        }
        return "dcs_climate:items/equip/" + s + this.tex;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int c;
        String name = PASS + this.tex;
        if (!DCUtil.isEmpty((ItemStack)stack) && (c = this.func_82814_b(stack)) > 0) {
            EnumDyeColor d = EnumDyeColor.func_176764_b((int)c);
            name = name + "_" + d;
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return name + "_layer_2.png";
        }
        return name + "_layer_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelThinBiped next;
        if (armorSlot == EntityEquipmentSlot.LEGS && (next = ClimateCore.proxy.getArmorModel(armorSlot.func_188454_b())) != null) {
            next.func_178686_a((ModelBase)_default);
            return next;
        }
        return _default;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (!DCUtil.isEmpty((ItemStack)stack) && this.getColorableList().length > 0) {
            String s = "NORMAL";
            for (EnumDyeColor d : this.getColorableList()) {
                if (d == null || d == EnumDyeColor.WHITE) continue;
                s = s + " " + ItemArmorDC.getChatColor(d) + d;
            }
            int c = this.func_82814_b(stack);
            if (c > 0) {
                EnumDyeColor dye = EnumDyeColor.func_176764_b((int)c);
                tooltip.add("Color: " + ItemArmorDC.getChatColor(dye) + dye);
            } else {
                tooltip.add("Color: NORMAL");
            }
            tooltip.add("==" + I18n.func_135052_a((String)"dcs.tip.cloth.color", (Object[])new Object[0]) + "==");
            tooltip.add(s);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack item) {
        return MainCoreConfig.armor_effect;
    }

    @Override
    public EnumDyeColor[] getColorableList() {
        return this.colorList;
    }

    @Override
    public EnumDyeColor getCurrentColor(ItemStack armor) {
        if (DCUtil.isEmpty((ItemStack)armor)) {
            return EnumDyeColor.WHITE;
        }
        int c = this.func_82814_b(armor);
        if (c > 0) {
            EnumDyeColor dye = EnumDyeColor.func_176764_b((int)c);
            return dye;
        }
        return EnumDyeColor.WHITE;
    }

    public EnumDyeColor getItemColor(ItemStack item) {
        if (DCUtil.isEmpty((ItemStack)item)) {
            return EnumDyeColor.WHITE;
        }
        if (this.getColorableList() != null && this.getColorableList().length > 0) {
            for (EnumDyeColor dye : this.getColorableList()) {
                EnumDyeColor d;
                if (dye == null || !DyeUtils.isDye((ItemStack)item) || (d = DyeUtils.colorFromStack((ItemStack)item).orElse(EnumDyeColor.WHITE)) != dye) continue;
                return dye;
            }
        }
        return EnumDyeColor.WHITE;
    }

    public int getColorNumber(ItemStack dyeItem) {
        EnumDyeColor d;
        EnumDyeColor dye = this.getItemColor(dyeItem);
        if (dye != null && DyeUtils.isDye((ItemStack)dyeItem) && (d = DyeUtils.colorFromStack((ItemStack)dyeItem).orElse(EnumDyeColor.WHITE)) == dye) {
            return d.func_176765_a();
        }
        return -1;
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("color") && tag.func_74762_e("color") >= 0;
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("color") && tag.func_74762_e("color") >= 0) {
            int ret = tag.func_74762_e("color");
            return ret;
        }
        return -1;
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("color")) {
            tag.func_82580_o("color");
        }
    }

    public void func_82813_b(ItemStack stack, int color) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("color", color);
    }

    public static String getChatColor(EnumDyeColor color) {
        int meta = color.func_176765_a();
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
        TextFormatting chat = MainUtil.DYE_CHAT_COLOR[meta];
        return chat.toString();
    }

    public static ItemStack setRondomColor(ItemStack stack) {
        if (DCUtil.isEmpty((ItemStack)stack)) {
            return stack;
        }
        if (stack.func_77973_b() instanceof ItemArmorDC && ((ItemArmorDC)stack.func_77973_b()).getColorableList() != null) {
            EnumDyeColor[] list = ((ItemArmorDC)stack.func_77973_b()).getColorableList();
            int c = field_77697_d.nextInt(list.length);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            tag.func_74768_a("color", list[c].func_176765_a());
            stack.func_77982_d(tag);
        }
        return stack;
    }
}

