/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.item.ores;

import defeatedcrow.hac.core.base.DCItem;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIngots
extends DCItem {
    private final int maxMeta;
    private static String[] names = new String[]{"copper", "zinc", "nickel", "silver", "brass", "steel", "nickelsilver", "magnet", "tin", "bronze", "sus", "titanium", "aluminium", "bismuth", "bscco", "lead", "manganese", "toolsteel", "mangalloy"};

    public ItemIngots(int max) {
        this.maxMeta = max;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        MathHelper.func_76125_a((int)meta, (int)0, (int)this.maxMeta);
        String s = "items/ores/ingot_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, World world, List<String> tooltip) {
        int i = stack.func_77952_i();
        if (i >= 0 && i <= this.maxMeta) {
            int tier = Metal.VALUES[i].tier;
            TextFormatting color = TextFormatting.YELLOW;
            if (tier > 2) {
                color = TextFormatting.GOLD;
            }
            if (tier > 1) {
                tooltip.add(color.toString() + "Tier " + Metal.VALUES[i].tier);
            } else {
                tooltip.add("Tier " + Metal.VALUES[i].tier);
            }
        }
    }

    public static enum Metal {
        COPPER("copper", 1),
        ZINC("zinc", 1),
        NICKEL("nickel", 2),
        SILVER("silver", 2),
        BRASS("brass", 1),
        STEEL("steel", 2),
        NICKELSILVER("nickelsilver", 2),
        MAGNET("magnet", 3),
        TIN("tin", 1),
        BRONZE("bronze", 1),
        SUS("sus", 3),
        TITANIUM("titanium", 3),
        ALUMINIUM("aluminium", 2),
        BISMUTH("bismuth", 1),
        BSCCO("bscco", 3),
        LEAD("lead", 1),
        MANGANESE("manganese", 3),
        TOOLSTEEL("toolsteel", 3),
        MANGALLOY("mangalloy", 3);

        public String name;
        public int tier;
        public static final Metal[] VALUES;

        private Metal(String s, int i) {
            this.name = s;
            this.tier = i;
        }

        static {
            VALUES = new Metal[]{COPPER, ZINC, NICKEL, SILVER, BRASS, STEEL, NICKELSILVER, MAGNET, TIN, BRONZE, SUS, TITANIUM, ALUMINIUM, BISMUTH, BSCCO, LEAD, MANGANESE, TOOLSTEEL, MANGALLOY};
        }
    }
}

