/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.item.tool;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.config.MainCoreConfig;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBullets
extends DCItem {
    private final int maxMeta;
    private static String[] names = new String[]{"bolt", "normal", "shot", "silver", "ghost", "light", "extinction", "crow"};
    public static Type[] values = new Type[]{Type.BOLT, Type.NORMAL, Type.SHOT, Type.SILVER, Type.GHOST, Type.LIGHT, Type.EXTINCTION, Type.CROW};

    public ItemBullets(int max) {
        this.maxMeta = max;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/misc/cartridge_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public static Type getType(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)7);
        return values[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            int m = stack.func_77952_i();
            switch (ItemBullets.getType(m)) {
                case BOLT: {
                    tooltip.add("Damage: " + MainCoreConfig.gun_damage * 0.5);
                    break;
                }
                case CROW: {
                    tooltip.add("No Damage");
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.balloon_bullet", (Object[])new Object[0]));
                    break;
                }
                case EXTINCTION: {
                    tooltip.add("No Damage");
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.extinction_bullet", (Object[])new Object[0]));
                    break;
                }
                case GHOST: {
                    tooltip.add("Damage: " + MainCoreConfig.gun_damage);
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.penetrate_block", (Object[])new Object[0]));
                    break;
                }
                case LIGHT: {
                    tooltip.add("No Damage");
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.light_bullet", (Object[])new Object[0]));
                    break;
                }
                case NORMAL: {
                    tooltip.add("Damage: " + MainCoreConfig.gun_damage);
                    break;
                }
                case SHOT: {
                    tooltip.add("Damage: " + MainCoreConfig.gun_damage);
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.penetrate_block", (Object[])new Object[0]));
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.ranged_attack", (Object[])new Object[0]));
                    break;
                }
                case SILVER: {
                    tooltip.add("Damage: " + MainCoreConfig.gun_damage);
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.silver_bullet", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    public static enum Type {
        BOLT,
        NORMAL,
        SILVER,
        SHOT,
        GHOST,
        LIGHT,
        EXTINCTION,
        CROW;

    }
}

