/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.item.tool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.util.LootTablesDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;

public class ItemHandNet
extends ItemTool
implements ITexturePath {
    public static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150321_G});
    BlockPos last = null;
    int def = 0;

    public ItemHandNet() {
        super(Item.ToolMaterial.STONE, EFFECTIVE_ON);
        this.func_77656_e(255);
        this.func_77625_d(1);
        this.func_77627_a(false);
        this.func_77664_n();
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/tool/hand_net";
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public int func_77619_b() {
        return 5;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            ItemStack item = player.func_184586_b(hand);
            if (!DCUtil.isEmpty((ItemStack)item)) {
                IBlockState state;
                BlockPos pos;
                RayTraceResult res = this.func_77621_a(world, player, true);
                if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175660_a(player, pos = res.func_178782_a()) && player.func_175151_a(pos.func_177972_a(res.field_178784_b), res.field_178784_b, item) && ((state = world.func_180495_p(pos)).func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i)) {
                    if (!world.field_72995_K) {
                        Biome biome = world.func_180494_b(player.func_180425_c());
                        FishType type = FishType.POND;
                        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                            type = FishType.OCEAN;
                        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                            type = FishType.RIVER;
                        }
                        List<ItemStack> fishes = this.getFishItem(world, player, type, item, pos);
                        if (!fishes.isEmpty() && !fishes.get(0).func_190926_b()) {
                            EntityItem drop = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, fishes.get(0));
                            drop.field_70159_w = world.field_73012_v.nextDouble() * 0.1;
                            drop.field_70181_x = world.field_73012_v.nextDouble() * 0.1 + 0.15;
                            drop.field_70179_y = world.field_73012_v.nextDouble() * 0.1;
                            drop.func_174867_a(5);
                            world.func_72838_d((Entity)drop);
                        }
                    }
                    for (int i = 0; i < 5; ++i) {
                        float f6 = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                        float f7 = MathHelper.func_151240_a((Random)world.field_73012_v, (float)25.0f, (float)60.0f);
                        double d4 = MathHelper.func_76126_a((float)f6) * f7 * 0.1f;
                        double d5 = (double)pos.func_177956_o() + 1.125;
                        double d6 = MathHelper.func_76134_b((float)f6) * f7 * 0.1f;
                        world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, d4, 0.2, d6, new int[0]);
                    }
                    world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    player.func_184609_a(hand);
                    item.func_77972_a(1, (EntityLivingBase)player);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                }
            } else {
                ActionResult ret = super.func_77659_a(world, player, hand);
                if (ret.func_188397_a() == EnumActionResult.PASS) {
                    player.func_184598_c(hand);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public List<ItemStack> getFishItem(World world, EntityPlayer player, FishType type, ItemStack tool, BlockPos pos) {
        ArrayList drops = Lists.newArrayList();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        int silk = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool);
        ResourceLocation loot = LootTableList.field_186390_ao;
        int r1 = this.getEnvironmentCount(world, pos);
        if (r1 < 20) {
            return drops;
        }
        int r = fortune * 10 + world.field_73012_v.nextInt(r1);
        if (silk <= 0) {
            if (r > 60) {
                if (world.field_73012_v.nextBoolean()) {
                    loot = LootTablesDC.TREASURE_LOOT;
                }
            } else {
                loot = type == FishType.OCEAN ? LootTablesDC.OCEAN_LOOT : (type == FishType.RIVER ? LootTablesDC.RIVER_LOOT : LootTablesDC.POND_LOOT);
            }
        }
        LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
        builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
        LootTable loottable = world.func_184146_ak().func_186521_a(loot);
        List result = loottable.func_186462_a(world.field_73012_v, builder.func_186471_a());
        if (result != null && !result.isEmpty()) {
            drops.addAll(result);
            return drops;
        }
        return drops;
    }

    private int getEnvironmentCount(World world, BlockPos pos) {
        this.def = this.last != null && pos.func_177951_i((Vec3i)this.last) < 2.0 ? (this.def += 10) : 0;
        this.last = pos;
        int ret = 50 - this.def;
        if (world.func_72896_J()) {
            ret += 20;
        }
        Iterable itr0 = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, 1, -1), (BlockPos)pos.func_177982_a(1, 1, 1));
        for (BlockPos p0 : itr0) {
            IBlockState st = world.func_180495_p(p0);
            if (st == null) continue;
            if (st.func_185904_a() == Material.field_151575_d || st.func_185904_a() == Material.field_151585_k) {
                ret += 5;
                continue;
            }
            if (!(st.func_177230_c() instanceof IPlantable)) continue;
            ret += 5;
        }
        Iterable itr1 = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1));
        int w1 = 0;
        for (BlockPos p1 : itr1) {
            IBlockState st = world.func_180495_p(p1);
            if (st == null) continue;
            if (st.func_185904_a() == Material.field_151586_h) {
                ++w1;
                continue;
            }
            if (st.func_185904_a() == Material.field_151575_d || st.func_185904_a() == Material.field_151585_k) {
                ret += 5;
                continue;
            }
            if (!(st.func_177230_c() instanceof IPlantable)) continue;
            ret += 5;
        }
        if (w1 < 2 || w1 > 7) {
            ret -= 20;
        }
        if (w1 == 4 || w1 == 5) {
            ret += 20;
        }
        Iterable itr2 = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, -1, 1));
        int w2 = 0;
        for (BlockPos p2 : itr2) {
            IBlockState st = world.func_180495_p(p2);
            if (st == null) continue;
            if (st.func_185904_a() == Material.field_151586_h) {
                ++w2;
                continue;
            }
            if (st.func_185904_a() == Material.field_151575_d || st.func_185904_a() == Material.field_151585_k) {
                ret += 5;
                continue;
            }
            if (st.func_177230_c() instanceof IPlantable) {
                ret += 5;
                continue;
            }
            if (st.func_185904_a() != Material.field_151577_b && st.func_185904_a() != Material.field_151595_p) continue;
            ret += 5;
        }
        if (w2 > 6) {
            ret -= 20;
        }
        if (w2 < 4) {
            ret += 20;
        }
        return ret;
    }

    public static enum FishType {
        OCEAN,
        RIVER,
        POND;

    }
}

