/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScytheDC
extends ItemSword
implements ITexturePath {
    private final float attackDam;
    private final String tex;
    public int range;

    public ItemScytheDC(Item.ToolMaterial m, String t) {
        super(m);
        this.tex = t;
        this.attackDam = 3.0f + m.func_78000_c();
        this.range = m.func_77996_d();
    }

    public String getTexPath(int meta, boolean isFull) {
        return "dcs_climate:items/tool/scythe_" + this.tex;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return true;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDam, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.5, 0));
        }
        return multimap;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C && material != Material.field_151569_G ? 1.0f : 15.0f;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase living) {
        int area = this.range + 1;
        for (int x = -area + 1; x < area; ++x) {
            for (int z = -area + 1; z < area; ++z) {
                for (int y = -1; y < 2; ++y) {
                    NonNullList l1;
                    EntityItem entityitem;
                    List drops;
                    IBlockState under;
                    BlockPos p1 = pos.func_177982_a(x, y, z);
                    IBlockState target = world.func_180495_p(p1);
                    ItemStack tool = stack.func_77946_l();
                    int fl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
                    if (living.func_70093_af()) {
                        tool = new ItemStack((Item)Items.field_151097_aZ);
                    }
                    if (!(this.func_150893_a(tool, target) > 1.0f) || target.func_177230_c() instanceof BlockStem) continue;
                    boolean flag = false;
                    if (target.func_177230_c() instanceof IShearable && ((IShearable)target.func_177230_c()).isShearable(tool, (IBlockAccess)world, p1)) {
                        flag = true;
                    }
                    if (target.func_177230_c() instanceof IGrowable && !((IGrowable)target.func_177230_c()).func_176473_a(world, p1, target, false)) {
                        flag = true;
                    }
                    if (target.func_177230_c() == Blocks.field_150423_aK || target.func_177230_c() == Blocks.field_150440_ba) {
                        flag = true;
                    }
                    if ((target.func_177230_c() == Blocks.field_150436_aH || target.func_177230_c() == Blocks.field_150434_aF) && (under = world.func_180495_p(p1.func_177977_b())).func_177230_c() == target.func_177230_c()) {
                        flag = true;
                    }
                    if (!flag) continue;
                    if (target.func_177230_c() instanceof BlockTallGrass) {
                        if (living.func_70093_af()) {
                            drops = ((IShearable)target.func_177230_c()).onSheared(tool, (IBlockAccess)world, p1, fl);
                            if (!world.field_72995_K) {
                                for (ItemStack i : drops) {
                                    entityitem = new EntityItem(world, (double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + 0.5, (double)p1.func_177952_p() + 0.5, i);
                                    entityitem.func_174869_p();
                                    world.func_72838_d((Entity)entityitem);
                                }
                            }
                        }
                        l1 = NonNullList.func_191196_a();
                        target.func_177230_c().getDrops(l1, (IBlockAccess)world, p1, target, fl);
                        if (!world.field_72995_K) {
                            for (ItemStack i : l1) {
                                entityitem = new EntityItem(world, (double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + 0.5, (double)p1.func_177952_p() + 0.5, i);
                                entityitem.func_174869_p();
                                world.func_72838_d((Entity)entityitem);
                            }
                        }
                    } else if (target.func_177230_c() instanceof IShearable) {
                        drops = ((IShearable)target.func_177230_c()).onSheared(tool, (IBlockAccess)world, p1, fl);
                        if (!world.field_72995_K) {
                            for (ItemStack i : drops) {
                                entityitem = new EntityItem(world, (double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + 0.5, (double)p1.func_177952_p() + 0.5, i);
                                entityitem.func_174869_p();
                                world.func_72838_d((Entity)entityitem);
                            }
                        }
                    } else if (target.func_177230_c() instanceof IGrowable) {
                        l1 = NonNullList.func_191196_a();
                        target.func_177230_c().getDrops(l1, (IBlockAccess)world, p1, target, fl);
                        if (!world.field_72995_K) {
                            for (ItemStack i : l1) {
                                entityitem = new EntityItem(world, (double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + 0.5, (double)p1.func_177952_p() + 0.5, i);
                                entityitem.func_174869_p();
                                world.func_72838_d((Entity)entityitem);
                            }
                        }
                    } else if (living instanceof EntityPlayer) {
                        target.func_177230_c().func_180657_a(world, (EntityPlayer)living, p1, target, null, tool);
                    } else {
                        target.func_177230_c().func_176226_b(world, p1, target, 0);
                    }
                    if (living instanceof EntityPlayer) {
                        target.func_177230_c().removedByPlayer(target, world, p1, (EntityPlayer)living, false);
                        continue;
                    }
                    world.func_175698_g(p1);
                }
            }
        }
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(1, living);
        }
        return true;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity == null || entity.field_70170_p.field_72995_K || player == null) {
            return false;
        }
        if (player.func_70093_af() && entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(itemstack, (IBlockAccess)entity.field_70170_p, pos)) {
                List drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
                Random rand = Item.field_77697_d;
                for (ItemStack stack : drops) {
                    EntityItem ent = entity.func_70099_a(stack, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                player.field_70170_p.func_184133_a(player, entity.func_180425_c(), SoundEvents.field_187763_eJ, SoundCategory.PLAYERS, 1.5f, 1.5f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + 0.5f);
                itemstack.func_77972_a(1, entity);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"dcs.tip.scythe1", (Object[])new Object[0]));
        tooltip.add("Range: " + (this.range + 1));
        tooltip.add(I18n.func_135052_a((String)"dcs.tip.scythe2", (Object[])new Object[0]));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (ModuleConfig.magic_advanced) {
            ItemStack main = playerIn.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack off = playerIn.func_184586_b(EnumHand.OFF_HAND);
            if (MainUtil.isHeldOffhandTool(new ItemStack(MagicInit.colorGauntlet, 1, 0), (EntityLivingBase)playerIn) && !DCUtil.isEmpty((ItemStack)main) && main.func_77973_b() == this) {
                playerIn.func_184598_c(handIn);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)main);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return ModuleConfig.magic_advanced && MainUtil.isHeldOffhandTool(new ItemStack(MagicInit.colorGauntlet, 1, 0), entity) && !DCUtil.isEmpty((ItemStack)stack) && stack.func_77973_b() == this;
    }
}

