/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.util.DCUtil;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemSwordDC
extends ItemSword
implements ITexturePath {
    private final float attackDam;
    private final String tex;
    private final boolean isShort;
    private boolean isToolsteel = false;

    public ItemSwordDC(Item.ToolMaterial m, String t, boolean b) {
        super(m);
        this.tex = t;
        this.attackDam = 1.0f + m.func_78000_c();
        this.isShort = b;
    }

    public ItemSwordDC setToolsteel() {
        this.isToolsteel = true;
        return this;
    }

    public String getTexPath(int meta, boolean isFull) {
        return "dcs_climate:items/tool/sword_" + this.tex;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (this.isToolsteel) {
            if (slot == EntityEquipmentSlot.MAINHAND) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(this.attackDam + 4.0f), 0));
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -0.2, 0));
            }
        } else if (this.isShort) {
            if (slot == EntityEquipmentSlot.MAINHAND) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDam, 0));
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 0.0, 0));
            }
        } else if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(this.attackDam + 4.0f), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.isToolsteel && target.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH)) {
            IItemHandler handler = (IItemHandler)target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!DCUtil.isEmpty((ItemStack)handler.getStackInSlot(i))) continue;
                int dam = 10 + target.field_70170_p.field_73012_v.nextInt(10);
                handler.getStackInSlot(i).func_77972_a(dam, target);
            }
        }
        stack.func_77972_a(1, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.isToolsteel) {
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.toolsteel.sword", (Object[])new Object[0]));
        }
    }
}

