/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.item.tool;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.base.DCItem;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTinderDC
extends DCItem {
    private final int maxMeta;
    private static String[] names = new String[]{"tinder", "fire", "firestarter"};

    public ItemTinderDC() {
        this.maxMeta = 2;
        this.func_77664_n();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        pos = pos.func_177972_a(facing);
        if (stack.func_77952_i() != 0) {
            IBlockState target = world.func_180495_p(pos);
            if (player.func_175151_a(pos, facing, stack)) {
                if (world.func_175623_d(pos)) {
                    world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
                }
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult ray = this.func_77621_a(world, player, true);
        if (stack.func_77952_i() != 0 || ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = ray.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        if (this.isFireObject(state, pos, world)) {
            world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)this, 1, 1));
            }
            if (!player.field_70170_p.field_72995_K) {
                EntityItem drop = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack((Item)this, 1, 1));
                drop.field_70159_w = 0.0;
                drop.field_70181_x = 0.0;
                drop.field_70179_y = 0.0;
                player.field_70170_p.func_72838_d((Entity)drop);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private boolean isFireObject(IBlockState state, BlockPos pos, World world) {
        if (state != null) {
            if (state.func_185904_a() == Material.field_151581_o || state.func_185904_a() == Material.field_151587_i) {
                return true;
            }
            if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151581_o) {
                return true;
            }
            if (state.func_177230_c() == Blocks.field_150478_aa || state.func_177230_c() == Blocks.field_150470_am || state.func_177230_c() == Blocks.field_150428_aP) {
                return true;
            }
            DCHeatTier heat = ClimateAPI.calculator.getBlockHeatTier(world, pos.func_177984_a(), pos);
            if (heat != null && heat.getTier() > DCHeatTier.BOIL.getTier()) {
                return true;
            }
        }
        return false;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (entity.func_70027_ad() || entity instanceof EntityBlaze) {
            if (stack.func_77952_i() == 0) {
                player.field_70170_p.func_184133_a(player, entity.func_180425_c(), SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                stack.func_190918_g(1);
                if (!player.field_70170_p.field_72995_K) {
                    EntityItem drop = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack((Item)this, 1, 1));
                    drop.field_70159_w = 0.0;
                    drop.field_70181_x = 0.0;
                    drop.field_70179_y = 0.0;
                    player.field_70170_p.func_72838_d((Entity)drop);
                }
                return true;
            }
        } else if (stack.func_77952_i() != 0) {
            player.field_70170_p.func_184133_a(player, entity.func_180425_c(), SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            stack.func_190918_g(1);
            entity.func_70015_d(30);
            return true;
        }
        return false;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/tool/tinderitem_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, World world, List<String> tooltip) {
        if (stack != null) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            int m = stack.func_77952_i();
            if (m == 0) {
                tooltip.add(I18n.func_135052_a((String)"dcs.tip.tinder", (Object[])new Object[0]));
            } else if (m == 1) {
                tooltip.add(I18n.func_135052_a((String)"dcs.tip.firestarter", (Object[])new Object[0]));
            } else if (m == 2) {
                tooltip.add(I18n.func_135052_a((String)"dcs.tip.firestarter", (Object[])new Object[0]));
            }
        }
    }
}

