/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.recipes;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.DCSidedBlock;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.machine.block.cont.BlockFuelCont;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.ICompressionRecipe;
import defeatedcrow.hac.main.block.ores.BlockDusts;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class BlockContainerUtil {
    public static BlockContainerUtil INS = new BlockContainerUtil();
    static final List<IBlockState> cont1 = Lists.newArrayList();
    static final List<IBlockState> cont2 = Lists.newArrayList();

    public static IBlockState getRondomContainer1(Random rand) {
        if (!cont1.isEmpty() && cont1.size() > 0) {
            int r = rand.nextInt(cont1.size());
            return cont1.get(r);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static IBlockState getRondomContainer2(Random rand) {
        if (!cont2.isEmpty() && cont2.size() > 0) {
            int r = rand.nextInt(cont2.size());
            return cont2.get(r);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static ReturnPair getReturnItem(ItemStack item) {
        ItemStack check;
        int[] ids;
        if (DCUtil.isEmpty((ItemStack)item)) {
            return null;
        }
        if (item.func_77973_b() == Items.field_151015_O) {
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(Blocks.field_150407_cf), 9);
        }
        if (item.func_77973_b() == Items.field_151123_aH) {
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(Blocks.field_180399_cE), 9);
        }
        if (item.func_77973_b() == Items.field_151137_ax) {
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(Blocks.field_150451_bX), 9);
        }
        if (item.func_77973_b() == Items.field_151128_bU) {
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(Blocks.field_150371_ca), 4);
        }
        if (item.func_77973_b() == MainInit.foodDust && item.func_77952_i() == 4) {
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.dustCake, 1, 4), 8);
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)item)) {
            NonNullList ores;
            String name = OreDictionary.getOreName((int)id);
            if (name.contains("ingot")) {
                NonNullList ores2;
                String split = BlockContainerUtil.getIngotName(name);
                if (split.length() > 0 && (ores2 = OreDictionary.getOres((String)("block" + split))) != null && !ores2.isEmpty()) {
                    BlockContainerUtil blockContainerUtil = INS;
                    blockContainerUtil.getClass();
                    return blockContainerUtil.new ReturnPair(((ItemStack)ores2.get(0)).func_77946_l(), 9);
                }
                return null;
            }
            if (!name.contains("gem")) continue;
            String split = BlockContainerUtil.getGemName(name);
            if (split.length() > 0 && (ores = OreDictionary.getOres((String)("block" + split))) != null && !ores.isEmpty()) {
                if (((ItemStack)ores.get(0)).func_77973_b() == Item.func_150898_a((Block)MainInit.gemBlock)) {
                    BlockContainerUtil blockContainerUtil = INS;
                    blockContainerUtil.getClass();
                    return blockContainerUtil.new ReturnPair(((ItemStack)ores.get(0)).func_77946_l(), 4);
                }
                BlockContainerUtil blockContainerUtil = INS;
                blockContainerUtil.getClass();
                return blockContainerUtil.new ReturnPair(((ItemStack)ores.get(0)).func_77946_l(), 9);
            }
            return null;
        }
        ItemStack[] dust = BlockDusts.containedItem();
        for (int i = 0; i < dust.length; ++i) {
            ItemStack check2 = dust[i];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check2, (boolean)false) && !MainUtil.hasSameDic(item, check2)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.dustBlock, 1, i), 9);
        }
        ItemStack[] cont1 = ((ICompressionRecipe)MainInit.cardboard).containedItem();
        for (int i1 = 0; i1 < cont1.length; ++i1) {
            ItemStack check3 = cont1[i1];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check3, (boolean)false) && !MainUtil.hasSameDic(item, check3)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.cardboard, 1, i1), 8);
        }
        ItemStack[] cont3 = ((ICompressionRecipe)MainInit.cropCont).containedItem();
        for (int i3 = 0; i3 < cont3.length; ++i3) {
            ItemStack check4 = cont3[i3];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check4, (boolean)false) && !MainUtil.hasSameDic(item, check4)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.cropCont, 1, i3), 8);
        }
        ItemStack[] cont4 = ((ICompressionRecipe)MainInit.dustBags).containedItem();
        for (int i4 = 0; i4 < cont4.length; ++i4) {
            ItemStack check5 = cont4[i4];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check5, (boolean)false) && !MainUtil.hasSameDic(item, check5)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.dustBags, 1, i4), 8);
        }
        ItemStack[] cont5 = ((ICompressionRecipe)MainInit.dropCont).containedItem();
        for (int i5 = 0; i5 < cont5.length; ++i5) {
            ItemStack check6 = cont5[i5];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check6, (boolean)false) && !MainUtil.hasSameDic(item, check6)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.dropCont, 1, i5), 8);
        }
        ItemStack[] cont6 = ((ICompressionRecipe)MainInit.logCont).containedItem();
        for (int i6 = 0; i6 < cont6.length; ++i6) {
            ItemStack check7 = cont6[i6];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check7, (boolean)false)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.logCont, 1, i6), 8);
        }
        ItemStack[] cont7 = ((ICompressionRecipe)MainInit.miscCont).containedItem();
        for (int i7 = 0; i7 < cont7.length; ++i7) {
            ItemStack check8 = cont7[i7];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check8, (boolean)false) && !MainUtil.hasSameDic(item, check8)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.miscCont, 1, i7), 8);
        }
        if (ModuleConfig.food) {
            ItemStack[] cont2 = ((ICompressionRecipe)MainInit.cropBasket).containedItem();
            for (int i2 = 0; i2 < cont2.length; ++i2) {
                ItemStack check9 = cont2[i2];
                if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check9, (boolean)false) && !MainUtil.hasSameDic(item, check9)) continue;
                BlockContainerUtil blockContainerUtil = INS;
                blockContainerUtil.getClass();
                return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.cropBasket, 1, i2), 8);
            }
            ItemStack[] cont9 = ((ICompressionRecipe)MainInit.cropJute).containedItem();
            for (int i9 = 0; i9 < cont9.length; ++i9) {
                check = cont9[i9];
                if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check, (boolean)false) && !MainUtil.hasSameDic(item, check)) continue;
                BlockContainerUtil blockContainerUtil = INS;
                blockContainerUtil.getClass();
                return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.cropJute, 1, i9), 8);
            }
        }
        ItemStack[] cont10 = ((ICompressionRecipe)MainInit.dustCake).containedItem();
        for (int i10 = 0; i10 < cont10.length; ++i10) {
            ItemStack check10 = cont10[i10];
            if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check10, (boolean)false) && !MainUtil.hasSameDic(item, check10)) continue;
            BlockContainerUtil blockContainerUtil = INS;
            blockContainerUtil.getClass();
            return blockContainerUtil.new ReturnPair(new ItemStack(MainInit.dustCake, 1, i10), 8);
        }
        if (ModuleConfig.machine) {
            ItemStack[] cont8 = BlockFuelCont.containedItem();
            for (int i8 = 0; i8 < cont8.length; ++i8) {
                check = cont8[i8];
                if (!DCUtil.isSameItem((ItemStack)item, (ItemStack)check, (boolean)false) && !MainUtil.hasSameDic(item, check)) continue;
                BlockContainerUtil blockContainerUtil = INS;
                blockContainerUtil.getClass();
                return blockContainerUtil.new ReturnPair(new ItemStack(MachineInit.fuelCont, 1, i8), 9);
            }
        }
        return null;
    }

    public static String getIngotName(String s) {
        String split = s.substring(5);
        if (split != null) {
            return split;
        }
        return "";
    }

    public static String getGemName(String s) {
        String split = s.substring(3);
        if (split != null) {
            return split;
        }
        return "";
    }

    public static void init() {
        int i;
        cont1.add(Blocks.field_150379_bu.func_176223_P());
        cont1.add(Blocks.field_150342_X.func_176223_P());
        cont1.add(Blocks.field_150423_aK.func_176223_P());
        cont1.add(Blocks.field_150421_aI.func_176223_P());
        cont1.add(Blocks.field_150360_v.func_176223_P());
        cont1.add(Blocks.field_150383_bp.func_176223_P());
        cont1.add(Blocks.field_150467_bQ.func_176223_P());
        cont1.add(Blocks.field_150367_z.func_176223_P());
        if (MachineInit.fuelCont != null && ModuleConfig.machine) {
            cont1.add(MachineInit.fuelCont.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(0)));
        }
        if (MainInit.miscCont != null) {
            for (i = 0; i < ((DCSimpleBlock)MainInit.miscCont).maxMeta; ++i) {
                cont1.add(MainInit.miscCont.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(i)));
            }
        }
        if (MainInit.dropCont != null) {
            for (i = 0; i < ((DCSimpleBlock)MainInit.dropCont).maxMeta; ++i) {
                cont1.add(MainInit.dropCont.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(i)));
            }
        }
        if (MainInit.cropCont != null) {
            for (i = 0; i < ((DCSimpleBlock)MainInit.cropCont).maxMeta; ++i) {
                cont2.add(MainInit.cropCont.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(i)));
            }
        }
        if (MainInit.cropBasket != null && ModuleConfig.food) {
            for (i = 0; i < ((DCSimpleBlock)MainInit.cropBasket).maxMeta; ++i) {
                cont2.add(MainInit.cropBasket.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(i)));
            }
        }
        if (MainInit.cardboard != null) {
            for (i = 0; i < ((DCSidedBlock)MainInit.cardboard).maxMeta; ++i) {
                cont2.add(MainInit.cardboard.func_176223_P().func_177226_a((IProperty)DCState.TYPE8, (Comparable)Integer.valueOf(i)));
            }
        }
        if (MainInit.dustBags != null) {
            for (i = 0; i < ((DCSidedBlock)MainInit.dustBags).maxMeta; ++i) {
                cont2.add(MainInit.dustBags.func_176223_P().func_177226_a((IProperty)DCState.TYPE8, (Comparable)Integer.valueOf(i)));
            }
        }
        if (MainInit.cropJute != null) {
            for (i = 0; i < ((DCSimpleBlock)MainInit.cropJute).maxMeta; ++i) {
                cont2.add(MainInit.cropJute.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(i)));
            }
        }
        if (MainInit.logCont != null) {
            for (i = 0; i < ((DCSidedBlock)MainInit.logCont).maxMeta; ++i) {
                cont2.add(MainInit.logCont.func_176223_P().func_177226_a((IProperty)DCState.TYPE8, (Comparable)Integer.valueOf(i)));
            }
        }
    }

    public class ReturnPair {
        public final ItemStack item;
        public final int count;

        private ReturnPair(ItemStack itemIn, int countIn) {
            this.item = itemIn;
            this.count = countIn;
        }
    }
}

