/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.recipes;

import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.main.api.IFluidFuel;
import defeatedcrow.hac.main.api.IFluidFuelRegister;
import defeatedcrow.hac.main.api.MainAPIManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class DCFluidFuelRegister
implements IFluidFuelRegister {
    private static List<IFluidFuel> list;

    public IFluidFuelRegister instance() {
        return MainAPIManager.fuelRegister;
    }

    public DCFluidFuelRegister() {
        list = new ArrayList<IFluidFuel>();
    }

    @Override
    public List<IFluidFuel> getFuelList() {
        return list;
    }

    @Override
    public void registerFuel(String name, Integer burnTime) {
        Fluid fluid = FluidRegistry.getFluid((String)name);
        if (fluid != null) {
            this.registerFuel(fluid, burnTime);
        }
    }

    @Override
    public void registerFuel(Fluid fluid, Integer burnTime) {
        if (!this.isRegistered(fluid) && burnTime > 0) {
            list.add(new FluidFuel(fluid, burnTime));
        }
    }

    @Override
    public boolean isRegistered(Fluid fluid) {
        for (IFluidFuel f : list) {
            if (!((FluidFuel)f).registered(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBurningTime(Fluid fluid) {
        for (IFluidFuel f : list) {
            if (!f.content(fluid)) continue;
            return f.getBurnTime();
        }
        return 0;
    }

    @Override
    public void removeFuel(Fluid fluid) {
        IFluidFuel ret = null;
        for (IFluidFuel f : list) {
            if (!((FluidFuel)f).registered(fluid)) continue;
            ret = f;
        }
        if (ret != null) {
            list.remove(ret);
        }
    }

    public class FluidFuel
    implements IFluidFuel {
        private final Fluid fluid;
        private final int time;

        public FluidFuel(Fluid f, int i) {
            this.fluid = f;
            this.time = i;
        }

        @Override
        public Fluid getFluid() {
            return this.fluid;
        }

        @Override
        public int getBurnTime() {
            return this.time;
        }

        @Override
        public boolean content(Fluid f) {
            return f.equals(this.fluid) || FluidDictionaryDC.matchFluid((Fluid)f, (Fluid)this.fluid);
        }

        public boolean registered(Fluid f) {
            return f != null && f.equals(this.fluid);
        }
    }
}

