/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.recipes;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.main.api.brewing.IAgingRecipeDC;
import java.util.ArrayList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FoodAgingRecipe
implements IAgingRecipeDC {
    private final FluidStack inputF;
    private final FluidStack outputF;
    private final int count;
    private static final ArrayList<Object> EMPTY = new ArrayList();

    public FoodAgingRecipe(FluidStack oF, FluidStack iF, int agingDay) {
        this.inputF = iF;
        this.outputF = oF;
        if (agingDay < 1) {
            agingDay = 1;
        }
        this.count = agingDay;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.inputF;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputF;
    }

    @Override
    public int agingDay() {
        return this.count;
    }

    @Override
    public boolean matches(FluidStack fluid) {
        boolean b1 = false;
        return fluid != null && this.inputF != null && (this.inputF.getFluid() == fluid.getFluid() || FluidDictionaryDC.matchFluid((Fluid)fluid.getFluid(), (Fluid)this.inputF.getFluid()));
    }

    @Override
    public boolean matchOutput(FluidStack fluid) {
        return true;
    }

    @Override
    public boolean matchClimate(IClimate climate) {
        if (climate != null) {
            if (climate.getHeat().getID() > DCHeatTier.HOT.getID() || climate.getHeat().getID() < DCHeatTier.COLD.getID()) {
                return false;
            }
            if (climate.getHumidity().getID() > DCHumidity.WET.getID()) {
                return false;
            }
            if (climate.getAirflow().getID() > DCAirflow.NORMAL.getID()) {
                return false;
            }
        }
        return true;
    }
}

