/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.recipes;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.recipe.IRecipePanel;
import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.api.brewing.IBrewingRecipeDC;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class FoodBrewingRecipe
implements IBrewingRecipeDC {
    private final Object[] input;
    private final FluidStack inputF;
    private ArrayList<Object> processedInput = new ArrayList();
    private ArrayList<Object> inputList = new ArrayList();
    private final ItemStack output;
    private final FluidStack outputF;
    private static final ArrayList<Object> EMPTY = new ArrayList();
    private int priority = 1;

    public FoodBrewingRecipe(ItemStack o, FluidStack oF, FluidStack iF, Object ... inputs) {
        this.input = inputs;
        this.inputF = iF;
        this.output = o;
        this.outputF = oF;
        if (inputs != null && inputs.length > 0) {
            for (int i = 0; i < inputs.length; ++i) {
                ItemStack ret;
                if (inputs[i] instanceof String) {
                    ret = new ArrayList();
                    ret.addAll(OreDictionary.getOres((String)((String)inputs[i])));
                    this.processedInput.add(ret);
                    this.inputList.add(inputs[i]);
                    continue;
                }
                if (inputs[i] instanceof ItemStack) {
                    if (DCUtil.isEmpty((ItemStack)((ItemStack)inputs[i]))) continue;
                    ret = ((ItemStack)inputs[i]).func_77946_l();
                    this.processedInput.add(ret);
                    this.inputList.add(ret);
                    continue;
                }
                if (inputs[i] instanceof Item) {
                    ret = new ItemStack((Item)inputs[i], 1, 0);
                    this.processedInput.add(ret);
                    this.inputList.add(ret);
                    continue;
                }
                if (inputs[i] instanceof Block) {
                    ret = new ItemStack((Block)inputs[i], 1, 0);
                    this.processedInput.add(ret);
                    this.inputList.add(ret);
                    continue;
                }
                throw new IllegalArgumentException("Unknown Object passed to recipe!");
            }
        }
    }

    public FoodBrewingRecipe priority(int i) {
        this.setPriority(i);
        return this;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.inputF;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputF;
    }

    @Override
    public Object[] getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput() {
        return DCUtil.isEmpty((ItemStack)this.output) ? ItemStack.field_190927_a : this.output.func_77946_l();
    }

    @Override
    public List<Object> getProcessedInput() {
        if (this.processedInput == null || this.processedInput.isEmpty()) {
            return EMPTY;
        }
        return new ArrayList<Object>(this.processedInput);
    }

    @Override
    public boolean matches(List<ItemStack> items, FluidStack fluid) {
        boolean b1 = false;
        if (this.inputF == null) {
            if (fluid == null) {
                b1 = true;
            }
        } else if (fluid != null && (this.inputF.getFluid() == fluid.getFluid() || FluidDictionaryDC.matchFluid((Fluid)fluid.getFluid(), (Fluid)this.inputF.getFluid()))) {
            boolean bl = b1 = this.inputF.amount <= fluid.amount;
        }
        if (b1) {
            ArrayList<Object> required = new ArrayList<Object>(this.inputList);
            if (required.isEmpty()) {
                for (int x = 0; x < items.size(); ++x) {
                    ItemStack slot = items.get(x);
                    if (DCUtil.isEmpty((ItemStack)slot)) continue;
                    return false;
                }
                return true;
            }
            for (int x = 0; x < items.size(); ++x) {
                ItemStack slot = items.get(x);
                if (DCUtil.isEmpty((ItemStack)slot) || slot.func_77973_b() instanceof IRecipePanel || required.isEmpty()) continue;
                boolean inRecipe = false;
                Iterator<Object> req = required.iterator();
                while (req.hasNext()) {
                    boolean match = false;
                    Object next = req.next();
                    if (next == null) continue;
                    if (next instanceof ItemStack) {
                        match = DCUtil.isSameItem((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                    } else if (next instanceof String) {
                        match = DCUtil.matchDicName((String)((String)next), (ItemStack)slot);
                    }
                    if (!match) continue;
                    inRecipe = true;
                    required.remove(next);
                    break;
                }
                req = null;
                if (inRecipe) continue;
                return false;
            }
            return required.isEmpty();
        }
        return false;
    }

    @Override
    public boolean matchOutput(List<ItemStack> items, FluidStack fluid) {
        boolean b1 = false;
        if (this.outputF == null || fluid == null) {
            b1 = true;
        } else {
            boolean bl = b1 = this.outputF.getFluid() == fluid.getFluid();
        }
        if (b1 && items != null && !items.isEmpty()) {
            if (DCUtil.isEmpty((ItemStack)this.getOutput())) {
                return true;
            }
            for (int i = 0; i < items.size(); ++i) {
                ItemStack get = items.get(i);
                if (!DCUtil.canInsert((ItemStack)this.getOutput(), (ItemStack)get)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matchClimate(IClimate climate) {
        if (climate != null) {
            if (climate.getHeat().getID() > DCHeatTier.HOT.getID() || climate.getHeat().getID() < DCHeatTier.COOL.getID()) {
                return false;
            }
            if (climate.getHumidity().getID() > DCHumidity.WET.getID() || climate.getHumidity().getID() < DCHumidity.NORMAL.getID()) {
                return false;
            }
            if (climate.getAirflow().getID() > DCAirflow.NORMAL.getID()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean additionalRequire(World world, BlockPos pos) {
        return true;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int i) {
        this.priority = i;
    }
}

