/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.recipes;

import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.api.brewing.IAgingRecipeDC;
import defeatedcrow.hac.main.api.brewing.IBrewingRecipeDC;
import defeatedcrow.hac.main.api.brewing.IBrewingRecipeRegister;
import defeatedcrow.hac.main.api.brewing.IStillRecipeDC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class FoodBrewingRecipeRegister
implements IBrewingRecipeRegister {
    private static List<IBrewingRecipeDC> brewing;
    private static List<IStillRecipeDC> still;
    private static List<IAgingRecipeDC> aging;

    public IBrewingRecipeRegister instance() {
        return MainAPIManager.brewingRegister;
    }

    public FoodBrewingRecipeRegister() {
        brewing = new ArrayList<IBrewingRecipeDC>();
        still = new ArrayList<IStillRecipeDC>();
        aging = new ArrayList<IAgingRecipeDC>();
    }

    @Override
    public List<IBrewingRecipeDC> getBrewingList() {
        return brewing;
    }

    @Override
    public List<IStillRecipeDC> getStillList() {
        return still;
    }

    @Override
    public List<IAgingRecipeDC> getAgingList() {
        return aging;
    }

    @Override
    public void addBrewingRecipe(IBrewingRecipeDC recipe) {
        if (recipe != null) {
            boolean b1 = recipe.getInput() == null && recipe.getInputFluid() == null;
            boolean b2 = DCUtil.isEmpty((ItemStack)recipe.getOutput()) && recipe.getOutputFluid() == null;
            boolean b3 = this.hasEmptyInput(recipe.getInput());
            if (!(b1 || b2 || b3)) {
                brewing.add(recipe);
            }
        }
    }

    @Override
    public void addStillRecipe(IStillRecipeDC recipe) {
        if (recipe != null) {
            boolean b1 = recipe.getInput() == null && recipe.getInputFluid() == null;
            boolean b2 = DCUtil.isEmpty((ItemStack)recipe.getOutput()) && recipe.getOutputFluid() == null;
            boolean b3 = this.hasEmptyInput(recipe.getInput());
            if (!(b1 || b2 || b3)) {
                still.add(recipe);
            }
        }
    }

    @Override
    public void addAgingRecipe(IAgingRecipeDC recipe) {
        if (recipe != null && recipe.getInputFluid() != null && recipe.getOutputFluid() != null) {
            aging.add(recipe);
        }
    }

    @Override
    public IBrewingRecipeDC getBrewingRecipe(IClimate clm, List<ItemStack> inputs, FluidStack inFluid) {
        for (IBrewingRecipeDC recipe : brewing) {
            if (!recipe.matches(inputs, inFluid) || !recipe.matchClimate(clm)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public IStillRecipeDC getStillRecipe(DCHeatTier hot, DCHeatTier cold, List<ItemStack> inputs, FluidStack inFluid) {
        for (IStillRecipeDC recipe : still) {
            if (!recipe.matches(inputs, inFluid) || !recipe.matchClimate(hot, cold)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public IAgingRecipeDC getAgingRecipe(IClimate clm, FluidStack inFluid) {
        for (IAgingRecipeDC recipe : aging) {
            if (!recipe.matches(inFluid) || !recipe.matchClimate(clm)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean removeBrewingRecipe(IClimate clm, List<ItemStack> inputs, FluidStack inFluid) {
        IBrewingRecipeDC recipe = this.getBrewingRecipe(clm, inputs, inFluid);
        return recipe != null && brewing.remove(recipe);
    }

    @Override
    public boolean removeStillRecipe(DCHeatTier hot, DCHeatTier cold, List<ItemStack> inputs, FluidStack inFluid) {
        IStillRecipeDC recipe = this.getStillRecipe(hot, cold, inputs, inFluid);
        return recipe != null && still.remove(recipe);
    }

    @Override
    public boolean removeAgingRecipe(IClimate clm, FluidStack inFluid) {
        IAgingRecipeDC recipe = this.getAgingRecipe(clm, inFluid);
        return recipe != null && aging.remove(recipe);
    }

    private boolean hasEmptyInput(Object[] inputs) {
        if (inputs != null && inputs.length > 0) {
            for (Object in : inputs) {
                if (in instanceof String) {
                    NonNullList l;
                    boolean ret = true;
                    if (OreDictionary.doesOreNameExist((String)((String)in)) && !(l = OreDictionary.getOres((String)((String)in))).isEmpty() && l.size() > 0) {
                        ret = false;
                    }
                    if (!ret) continue;
                    return true;
                }
                if (in != null) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

