/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.recipes;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.api.IHeatTreatment;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;

public class HeatTreatment
implements IHeatTreatment {
    public final List<ItemStack> input1 = Lists.newArrayList();
    public final ItemStack input2;
    public final ItemStack input3;
    public final ItemStack output;
    public final ItemStack failure;
    public final List<DCHeatTier> temp1 = Lists.newArrayList();
    public final List<DCHumidity> hum1 = Lists.newArrayList();
    public final List<DCAirflow> air1 = Lists.newArrayList();
    public final List<DCHeatTier> temp2 = Lists.newArrayList();
    public final List<DCHumidity> hum2 = Lists.newArrayList();
    public final List<DCAirflow> air2 = Lists.newArrayList();
    public final List<DCHeatTier> temp3 = Lists.newArrayList();
    public final List<DCHumidity> hum3 = Lists.newArrayList();
    public final List<DCAirflow> air3 = Lists.newArrayList();
    public int time1 = 100;
    public int time2 = 100;
    public int time3 = 100;

    public HeatTreatment(List<ItemStack> inputs, IClimate climate1, ItemStack secondary, IClimate climate2, ItemStack tertialy, IClimate climate3, ItemStack out, ItemStack fail) {
        this.input1.addAll(inputs);
        if (climate1 != null) {
            this.temp1.add(climate1.getHeat());
            this.hum1.add(climate1.getHumidity());
            this.air1.add(climate1.getAirflow());
        }
        this.input2 = secondary;
        if (climate2 != null) {
            this.temp2.add(climate2.getHeat());
            this.hum2.add(climate2.getHumidity());
            this.air2.add(climate2.getAirflow());
        }
        this.input3 = tertialy;
        if (climate3 != null) {
            this.temp3.add(climate3.getHeat());
            this.hum3.add(climate3.getHumidity());
            this.air3.add(climate3.getAirflow());
        }
        this.output = out;
        this.failure = fail;
    }

    @Override
    public List<ItemStack> getInput1() {
        return this.input1;
    }

    @Override
    public List<DCHeatTier> getTemp1() {
        return this.temp1;
    }

    @Override
    public List<DCHumidity> getHum1() {
        return this.hum1;
    }

    @Override
    public List<DCAirflow> getAir1() {
        return this.air1;
    }

    @Override
    public int getBurnTime1() {
        return this.time1;
    }

    @Override
    public ItemStack getInput2() {
        return this.input2;
    }

    @Override
    public List<DCHeatTier> getTemp2() {
        return this.temp2;
    }

    @Override
    public List<DCHumidity> getHum2() {
        return this.hum2;
    }

    @Override
    public List<DCAirflow> getAir2() {
        return this.air2;
    }

    @Override
    public int getBurnTime2() {
        return this.time2;
    }

    @Override
    public ItemStack getInput3() {
        return this.input3;
    }

    @Override
    public List<DCHeatTier> getTemp3() {
        return this.temp3;
    }

    @Override
    public List<DCHumidity> getHum3() {
        return this.hum3;
    }

    @Override
    public List<DCAirflow> getAir3() {
        return this.air3;
    }

    @Override
    public int getBurnTime3() {
        return this.time3;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public ItemStack getFail() {
        return this.failure;
    }

    @Override
    public ActionResult<ItemStack> getCurrentOutput(ItemStack in, IClimate climate) {
        if (this.matchClimate3(climate) && DCUtil.isSameItem((ItemStack)in, (ItemStack)this.input3, (boolean)false)) {
            if (!DCUtil.isEmpty((ItemStack)this.output)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.output.func_77946_l());
            }
        } else if (this.matchClimate2(climate) && DCUtil.isSameItem((ItemStack)in, (ItemStack)this.input2, (boolean)false)) {
            if (!DCUtil.isEmpty((ItemStack)this.input3)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.input3.func_77946_l());
            }
            if (!DCUtil.isEmpty((ItemStack)this.output)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.output.func_77946_l());
            }
        } else {
            for (ItemStack i1 : this.input1) {
                if (!DCUtil.isSameItem((ItemStack)in, (ItemStack)i1, (boolean)false)) continue;
                if (this.matchClimate1(climate)) {
                    if (!DCUtil.isEmpty((ItemStack)this.input2)) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)this.input2.func_77946_l());
                    }
                    if (!DCUtil.isEmpty((ItemStack)this.input3)) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)this.input3.func_77946_l());
                    }
                    if (DCUtil.isEmpty((ItemStack)this.output)) continue;
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)this.output.func_77946_l());
                }
                if (this.matchClimate1(climate.addTempTier(1))) continue;
                return new ActionResult(EnumActionResult.FAIL, (Object)in.func_77946_l());
            }
        }
        return DCUtil.isEmpty((ItemStack)this.failure) ? new ActionResult(EnumActionResult.FAIL, (Object)ItemStack.field_190927_a) : new ActionResult(EnumActionResult.FAIL, (Object)this.failure.func_77946_l());
    }

    @Override
    public boolean matchClimate1(IClimate clm) {
        if (clm == null) {
            return false;
        }
        boolean a = this.temp1.isEmpty() || this.temp1.contains(clm.getHeat());
        boolean b = this.hum1.isEmpty() || this.hum1.contains(clm.getHumidity());
        boolean c = this.air1.isEmpty() || this.air1.contains(clm.getAirflow());
        return a && b && c;
    }

    @Override
    public boolean matchClimate2(IClimate clm) {
        if (clm == null) {
            return false;
        }
        boolean a = this.temp2.isEmpty() || this.temp2.contains(clm.getHeat());
        boolean b = this.hum2.isEmpty() || this.hum2.contains(clm.getHumidity());
        boolean c = this.air2.isEmpty() || this.air2.contains(clm.getAirflow());
        return a && b && c;
    }

    @Override
    public boolean matchClimate3(IClimate clm) {
        if (clm == null) {
            return false;
        }
        boolean a = this.temp3.isEmpty() || this.temp3.contains(clm.getHeat());
        boolean b = this.hum3.isEmpty() || this.hum3.contains(clm.getHumidity());
        boolean c = this.air3.isEmpty() || this.air3.contains(clm.getAirflow());
        return a && b && c;
    }
}

