/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomExplosion
extends Explosion {
    private final double expX;
    private final double expY;
    private final double expZ;
    private final Entity bomb;
    private float size;
    private final Random rand = new Random();
    private final World worldObj;
    private final EntityLivingBase igniter;
    private final Type type;
    private Map playerMap = new HashMap();
    private final Vec3d pos;

    public CustomExplosion(World world, Entity source, EntityLivingBase ign, double posX, double posY, double posZ, float sizeIn, Type t, boolean smoke) {
        super(world, (Entity)ign, posX, posY, posZ, sizeIn, false, smoke);
        this.worldObj = world;
        this.type = t;
        this.igniter = ign;
        this.bomb = source;
        this.size = sizeIn;
        this.expX = posX;
        this.expY = posY;
        this.expZ = posZ;
        this.pos = new Vec3d(this.expX, this.expY, this.expZ);
    }

    public void doExplosion() {
        float f = this.size;
        int i = 0;
        int j = 0;
        int k = 0;
        double d5 = this.expX;
        double d6 = this.expY;
        double d7 = this.expZ;
        this.size *= 2.0f;
        i = MathHelper.func_76128_c((double)(this.expX - (double)this.size - 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.expX + (double)this.size + 1.0));
        j = MathHelper.func_76128_c((double)(this.expY - (double)this.size - 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.expY + (double)this.size + 1.0));
        k = MathHelper.func_76128_c((double)(this.expZ - (double)this.size - 1.0));
        int k2 = MathHelper.func_76128_c((double)(this.expZ + (double)this.size + 1.0));
        List list = this.worldObj.func_72839_b(this.bomb, new AxisAlignedBB((double)i, (double)j, (double)k, (double)i2, (double)j2, (double)k2));
        ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, (List)list, (double)(f * 2.0f));
        Vec3d vec3 = new Vec3d(this.expX, this.expY, this.expZ);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d4;
            Entity entity = (Entity)list.get(i1);
            if (entity == null || !entity.func_70089_S() || entity.func_180427_aV() || !((d4 = entity.func_70011_f(this.expX, this.expY, this.expZ) / (double)this.size) <= 1.0) || !(d4 > 0.0)) continue;
            double d11 = 1.0 - d4;
            d5 = entity.field_70165_t - this.expX;
            d6 = entity.field_70163_u - this.expY;
            d7 = entity.field_70161_v - this.expZ;
            d5 *= d11;
            d6 *= d11;
            d7 *= d11;
            boolean flag = true;
            float damage = (float)((double)(this.size * this.size * 2.0f) * (d11 * d11));
            damage = Math.max(damage, 4.0f);
            if (entity == this.igniter || entity == this.bomb) {
                flag = false;
            } else if (entity instanceof EntityBoat || entity instanceof EntityMinecart) {
                flag = false;
            } else if (entity instanceof EntityPlayer) {
                if (this.igniter instanceof EntityPlayer) {
                    flag = ((EntityPlayer)this.igniter).func_96122_a((EntityPlayer)entity);
                }
            } else if (this.type == Type.Silk) {
                if (entity instanceof EntityItem || entity instanceof IProjectile) {
                    flag = false;
                }
                damage *= 0.5f;
            } else if (this.type == Type.Anchor) {
                if (entity instanceof EntityDragon) {
                    damage *= 2.0f;
                } else if (!entity.field_70122_E) {
                    damage *= 10.0f;
                }
            }
            if (!flag) continue;
            if (entity instanceof IProjectile) {
                entity.func_70106_y();
            } else {
                entity.field_70172_ad = 0;
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), damage);
            }
            entity.field_70181_x += 0.3;
        }
    }

    public void doExplosionEffect(boolean eff, boolean flame) {
        this.worldObj.func_184148_a((EntityPlayer)null, this.expX, this.expY, this.expZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.1f * this.size) * 0.7f);
        if (this.size >= 3.0f && eff) {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.expX, this.expY, this.expZ, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.expX, this.expY, this.expZ, 1.0, 0.0, 0.0, new int[0]);
        }
        if (flame) {
            for (BlockPos blockpos1 : this.func_180343_e()) {
                if (this.worldObj.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.worldObj.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.rand.nextInt(3) != 0) continue;
                this.worldObj.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public static enum Type {
        Silk,
        Anchor,
        Normal;

    }
}

