/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.util;

import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.util.DCCoordinate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class DCChunkloadContoroller
implements ForgeChunkManager.LoadingCallback {
    private static DCChunkloadContoroller instance;
    protected static final HashMap<DCCoordinate, ForgeChunkManager.Ticket> ticketList;
    protected static final ArrayList<ForgeChunkManager.Ticket> allTicket;

    private DCChunkloadContoroller() {
    }

    public static DCChunkloadContoroller getInstance() {
        if (instance == null) {
            instance = new DCChunkloadContoroller();
        }
        return instance;
    }

    public void preInit() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ClimateMain.instance, (ForgeChunkManager.LoadingCallback)instance);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket t : tickets) {
            if (!this.isBlockTicket(t)) continue;
            int x = t.getModData().func_74762_e("x");
            int y = t.getModData().func_74762_e("y");
            int z = t.getModData().func_74762_e("z");
            int i = t.getModData().func_74762_e("i");
            int j = t.getModData().func_74762_e("j");
            int d = t.getModData().func_74762_e("d");
            DCCoordinate cood = new DCCoordinate(i, j, d);
            BlockPos pos = new BlockPos(x, y, z);
            if (this.getBlock(t, world) instanceof IChunkBlock) {
                IChunkBlock block = (IChunkBlock)this.getBlock(t, world);
                if (block.canLoad(world, x, y, z)) {
                    DCChunkloadContoroller.setBlockTicket(world, x, y, z, i, j, d);
                    continue;
                }
                DCChunkloadContoroller.deleteBlockTicket(world, x, y, z, i, j, d);
                continue;
            }
            DCChunkloadContoroller.deleteBlockTicket(world, x, y, z, i, j, d);
        }
    }

    public static boolean setBlockTicket(World world, int x, int y, int z, int i, int j, int d) {
        DCCoordinate cood = new DCCoordinate(i, j, d);
        boolean b = false;
        ForgeChunkManager.Ticket t = ForgeChunkManager.requestTicket((Object)ClimateMain.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (t == null) {
            return false;
        }
        DCChunkloadContoroller.setBlockType(t);
        DCChunkloadContoroller.setBlock(t, x, y, z, i, j, d);
        ticketList.put(cood, t);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)t, (ChunkPos)world.func_72964_e(i, j).func_76632_l());
        DCLogger.infoLog((String)("Succeed to register chunkloader. Cood: " + i + ", " + j));
        return true;
    }

    public static void deleteBlockTicket(World world, int x, int y, int z, int i, int j, int d) {
        DCCoordinate cood = new DCCoordinate(i, j, d);
        if (ticketList.containsKey(cood)) {
            if (!ForgeChunkManager.getPersistentChunksFor((World)DCChunkloadContoroller.ticketList.get((Object)cood).world).isEmpty()) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticketList.get(cood), (ChunkPos)world.func_72964_e(i, j).func_76632_l());
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticketList.get(cood));
            }
            ticketList.remove(cood);
            DCLogger.infoLog((String)("Succeed to delete chunkloader. Cood: " + i + ", " + j));
        }
    }

    public static void setBlockType(ForgeChunkManager.Ticket ticket) {
        ticket.getModData().func_74778_a("type", "dcblock");
    }

    public boolean isBlockTicket(ForgeChunkManager.Ticket ticket) {
        return ticket.getModData().func_74779_i("type").equals("dcblock");
    }

    public static void setBlock(ForgeChunkManager.Ticket ticket, int x, int y, int z, int i, int j, int d) {
        ticket.getModData().func_74768_a("x", x);
        ticket.getModData().func_74768_a("y", y);
        ticket.getModData().func_74768_a("z", z);
        ticket.getModData().func_74768_a("i", i);
        ticket.getModData().func_74768_a("j", j);
        ticket.getModData().func_74768_a("d", d);
    }

    public Block getBlock(ForgeChunkManager.Ticket ticket, World world) {
        BlockPos pos = new BlockPos(ticket.getModData().func_74762_e("x"), ticket.getModData().func_74762_e("y"), ticket.getModData().func_74762_e("z"));
        return world.func_180495_p(pos).func_177230_c();
    }

    private static ForgeChunkManager.Ticket getTicketFromList(DCCoordinate cood) {
        if (allTicket.isEmpty()) {
            return null;
        }
        for (ForgeChunkManager.Ticket t : allTicket) {
            int d;
            int j;
            int i = t.getModData().func_74762_e("i");
            DCCoordinate cood1 = new DCCoordinate(i, j = t.getModData().func_74762_e("j"), d = t.getModData().func_74762_e("d"));
            if (!cood1.equals(cood)) continue;
            return t;
        }
        return null;
    }

    static {
        ticketList = new HashMap();
        allTicket = new ArrayList();
    }

    public static interface IChunkBlock {
        public boolean canLoad(World var1, int var2, int var3, int var4);
    }
}

