/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.util;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.api.energy.IWrenchDC;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.plugin.baubles.DCPluginBaubles;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.IMagicClothing;
import defeatedcrow.hac.main.worldgen.vein.OreSetDC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class MainUtil {
    public static final String BR = System.getProperty("line.separator");
    public static final String[] DYES = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    public static TextFormatting[] DYE_CHAT_COLOR = new TextFormatting[]{TextFormatting.WHITE, TextFormatting.GOLD, TextFormatting.LIGHT_PURPLE, TextFormatting.AQUA, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_GRAY, TextFormatting.GRAY, TextFormatting.DARK_AQUA, TextFormatting.DARK_PURPLE, TextFormatting.BLUE, TextFormatting.DARK_RED, TextFormatting.GREEN, TextFormatting.RED, TextFormatting.DARK_GRAY};
    public static final int[][][] MATRIX = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};

    public static ItemStack getIngot(int meta) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 17) {
            meta = 17;
        }
        return new ItemStack(MainInit.oreIngot, 1, meta);
    }

    public static ItemStack getGem(Item gem, int meta) {
        return new ItemStack(gem, 1, meta);
    }

    public static ItemStack getRandomGem(int i) {
        int meta = DCUtil.rand.nextInt(27);
        if (meta < 4) {
            return new ItemStack(MainInit.gems_red, i, meta);
        }
        if (meta < 9) {
            int m = meta - 4;
            return new ItemStack(MainInit.gems_green, i, m);
        }
        if (meta < 15) {
            int m = meta - 9;
            return new ItemStack(MainInit.gems_blue, i, m);
        }
        if (meta < 21) {
            int m = meta - 15;
            return new ItemStack(MainInit.gems_white, i, m);
        }
        if (meta < 27) {
            int m = meta - 21;
            return new ItemStack(MainInit.gems_black, i, m);
        }
        return new ItemStack(MainInit.gems_red, i, 1);
    }

    public static ItemStack getRandomGem2(int i) {
        ItemStack ret = MainUtil.getRandomGem(i);
        if (ret.func_77952_i() == 0) {
            ret.func_77964_b(1);
        }
        return ret;
    }

    public static ItemStack getCrop(int meta) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 20) {
            meta = 20;
        }
        return new ItemStack(FoodInit.crops, 1, meta);
    }

    public static ItemStack getRandomCrop(int i) {
        int meta = DCUtil.rand.nextInt(21);
        return new ItemStack(FoodInit.crops, i, meta);
    }

    public static ItemStack getSeed(int meta) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 16) {
            meta = 16;
        }
        return new ItemStack(FoodInit.seeds, 1, meta);
    }

    public static ItemStack getRandomSeed(int i) {
        int meta = DCUtil.rand.nextInt(17);
        return new ItemStack(FoodInit.seeds, i, meta);
    }

    public static ItemStack getCloth(int meta) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 13) {
            meta = 13;
        }
        return new ItemStack(MainInit.clothes, 1, meta);
    }

    public static ItemStack getBasket(int meta) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 14) {
            meta = 14;
        }
        return new ItemStack(MainInit.cropBasket, 1, meta);
    }

    public static ItemStack getRandomBasket(int i) {
        int meta = DCUtil.rand.nextInt(15);
        return new ItemStack(MainInit.cropBasket, i, meta);
    }

    public static ItemStack getRandomCont(int i) {
        int meta = DCUtil.rand.nextInt(12);
        return new ItemStack(MainInit.cropCont, i, meta);
    }

    public static ItemStack getRandomCardboard(int i) {
        int meta = DCUtil.rand.nextInt(6);
        return new ItemStack(MainInit.cardboard, i, meta);
    }

    public static ItemStack getRandomBag(int i) {
        int meta = DCUtil.rand.nextInt(8);
        return new ItemStack(MainInit.dustBags, i, meta);
    }

    public static ItemStack getRandomCoating(int i) {
        int meta = DCUtil.rand.nextInt(9);
        return new ItemStack(MachineInit.platingChrome, i, meta);
    }

    public static ItemStack getRandomSapling(int i) {
        int meta = DCUtil.rand.nextInt(8);
        if (meta < 4) {
            return new ItemStack(FoodInit.saplings, i, meta);
        }
        if (meta < 6) {
            return new ItemStack(FoodInit.saplings2, i, meta - 4);
        }
        return meta == 6 ? new ItemStack(FoodInit.cropWisteria, i, 0) : new ItemStack(FoodInit.cropGrape, i, 0);
    }

    public static ItemStack getRandomRing(int i) {
        int meta = DCUtil.rand.nextInt(4);
        return new ItemStack(MagicInit.colorRing, i, meta);
    }

    public static ItemStack getRandomLogCont(int i) {
        int meta = DCUtil.rand.nextInt(6);
        return new ItemStack(MainInit.logCont, i, meta);
    }

    public static ItemStack getRandomBuildingBlock(int i) {
        int meta = DCUtil.rand.nextInt(4);
        switch (meta) {
            case 0: {
                return new ItemStack(MainInit.builds, i, 0);
            }
            case 1: {
                return new ItemStack(MainInit.gemBlock, i, 6);
            }
            case 2: {
                return new ItemStack(MainInit.gemBlock, i, 3);
            }
        }
        return new ItemStack(MainInit.layerNew, i, 1);
    }

    public static boolean removeBadPotion(EntityLivingBase liv) {
        if (liv != null && !liv.func_130014_f_().field_72995_K) {
            ArrayList remove = Lists.newArrayList();
            for (PotionEffect p : liv.func_70651_bq()) {
                if (!p.func_188419_a().func_76398_f()) continue;
                remove.add(p);
            }
            for (PotionEffect p2 : remove) {
                liv.func_184596_c(p2.func_188419_a());
            }
            return !remove.isEmpty();
        }
        return false;
    }

    public static boolean isHeldWrench(EntityLivingBase player, EnumHand hand) {
        ItemStack main = player.func_184586_b(hand);
        return !DCUtil.isEmpty((ItemStack)main) && main.func_77973_b() instanceof IWrenchDC;
    }

    public static boolean isHeldItem(Item item, EntityLivingBase player) {
        if (item == null || player == null) {
            return false;
        }
        return MainUtil.isHeldItem(new ItemStack(item, 1, 0), player);
    }

    public static boolean isHeldItem(ItemStack item, EntityLivingBase player) {
        if (DCUtil.isEmpty((ItemStack)item) || player == null) {
            return false;
        }
        if (DCUtil.isSameItem((ItemStack)item, (ItemStack)player.func_184586_b(EnumHand.MAIN_HAND), (boolean)false)) {
            return true;
        }
        return DCUtil.isSameItem((ItemStack)item, (ItemStack)player.func_184586_b(EnumHand.OFF_HAND), (boolean)false);
    }

    public static boolean isHeldOffhandTool(ItemStack item, EntityLivingBase player) {
        if (item == null || player == null) {
            return false;
        }
        return DCUtil.isSameItem((ItemStack)item, (ItemStack)player.func_184586_b(EnumHand.OFF_HAND), (boolean)false);
    }

    public static int getCharmLevel(EntityLivingBase living, ItemStack item) {
        if (living == null || DCUtil.isEmpty((ItemStack)item)) {
            return 0;
        }
        if (living instanceof EntityPlayer) {
            NonNullList charms = DCUtil.getPlayerCharm((EntityPlayer)((EntityPlayer)living), null);
            for (ItemStack check : charms) {
                if (DCUtil.isEmpty((ItemStack)check) || !OreDictionary.itemMatches((ItemStack)check, (ItemStack)item, (boolean)false)) continue;
                return check.func_190916_E();
            }
        } else {
            NonNullList charms = DCUtil.getMobCharm((EntityLivingBase)living);
            for (ItemStack check : charms) {
                if (DCUtil.isEmpty((ItemStack)check) || !OreDictionary.itemMatches((ItemStack)check, (ItemStack)item, (boolean)false)) continue;
                return check.func_190916_E();
            }
        }
        return 0;
    }

    public static ItemStack getCharmItem(EntityLivingBase living, ItemStack item) {
        block5: {
            block4: {
                if (living == null || DCUtil.isEmpty((ItemStack)item)) {
                    return ItemStack.field_190927_a;
                }
                if (!(living instanceof EntityPlayer)) break block4;
                for (int i = 9; i < 18; ++i) {
                    ItemStack check = ((EntityPlayer)living).field_71071_by.func_70301_a(i);
                    if (DCUtil.isEmpty((ItemStack)check) || !OreDictionary.itemMatches((ItemStack)check, (ItemStack)item, (boolean)false)) continue;
                    return check;
                }
                if (!Loader.isModLoaded((String)"baubles")) break block5;
                for (ItemStack check : DCPluginBaubles.getBaublesCharm((EntityPlayer)((EntityPlayer)living), null)) {
                    if (DCUtil.isEmpty((ItemStack)check) || !OreDictionary.itemMatches((ItemStack)check, (ItemStack)item, (boolean)false)) continue;
                    return check;
                }
                break block5;
            }
            NonNullList charms = DCUtil.getMobCharm((EntityLivingBase)living);
            for (ItemStack check : charms) {
                if (DCUtil.isEmpty((ItemStack)check) || !OreDictionary.itemMatches((ItemStack)check, (ItemStack)item, (boolean)false)) continue;
                return check;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static float magicSuitEff(EntityLivingBase owner) {
        if (owner != null) {
            float f = 1.0f;
            for (ItemStack armor : owner.func_184193_aE()) {
                if (DCUtil.isEmpty((ItemStack)armor) || !(armor.func_77973_b() instanceof IMagicClothing)) continue;
                f += ((IMagicClothing)armor.func_77973_b()).getEffect();
            }
            return f;
        }
        return 1.0f;
    }

    public static Set<BlockPos> getLumberTargetList(World world, BlockPos pos, Block block, int limit) {
        List<Object> nextTargets = new ArrayList<BlockPos>();
        nextTargets.add(pos);
        LinkedHashSet<BlockPos> founds = new LinkedHashSet<BlockPos>();
        do {
            nextTargets = nextTargets.stream().flatMap(target -> Arrays.stream(EnumFacing.values()).map(arg_0 -> ((BlockPos)target).func_177972_a(arg_0))).filter(fixedPos -> world.func_180495_p(fixedPos).func_177230_c().equals(block)).limit(limit - founds.size()).filter(founds::add).collect(Collectors.toList());
        } while (founds.size() <= limit && !nextTargets.isEmpty());
        return founds;
    }

    public static boolean hasSameDic(ItemStack item, ItemStack check) {
        if (!DCUtil.isEmpty((ItemStack)item) && !DCUtil.isEmpty((ItemStack)check)) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)check);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)item);
            if (ids.length < 1 || ids2.length < 1) {
                return false;
            }
            for (int id : ids) {
                for (int id2 : ids2) {
                    String s;
                    if (id != id2 || (s = OreDictionary.getOreName((int)id)).contains("All") || s.contains("dye") || s.contains("list") || s.contains("Any")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasDic(ItemStack item, String check) {
        if (!DCUtil.isEmpty((ItemStack)item) && check != null) {
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)item);
            if (ids2 == null || ids2.length < 1) {
                return false;
            }
            for (int id2 : ids2) {
                String s = OreDictionary.getOreName((int)id2);
                if (!s.equalsIgnoreCase(check)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDicPart(String name, ItemStack item) {
        if (name == null || DCUtil.isEmpty((ItemStack)item)) {
            return false;
        }
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)item);
        if (ids2 == null || ids2.length < 1) {
            return false;
        }
        for (int id2 : ids2) {
            String s = OreDictionary.getOreName((int)id2);
            if (!s.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static List<BlockSet> getListFromStrings(String[] names, String logname) {
        ArrayList list = Lists.newArrayList();
        if (names != null && names.length > 0) {
            for (String name : names) {
                BlockSet set = MainUtil.getBlockSetFromString(name);
                if (set == null || set.equals((Object)OreSetDC.AIR)) continue;
                DCLogger.infoLog((String)(logname + " add target: " + set.toString()));
                list.add(set);
            }
        }
        return list;
    }

    public static BlockSet getBlockSetFromString(String name) {
        Block block;
        String[] n2;
        if (name == null || name.equalsIgnoreCase("empty")) {
            return OreSetDC.AIR;
        }
        String itemName = name;
        String modid = "minecraft";
        int meta = Short.MAX_VALUE;
        if (name.contains(":") && (n2 = name.split(":")) != null && n2.length > 0) {
            if (n2.length > 2) {
                Integer m = null;
                try {
                    m = Integer.parseInt(n2[2]);
                }
                catch (NumberFormatException e) {
                    DCLogger.debugLog((String)("Tried to parse non Integer target: " + n2[2]));
                }
                if (m != null && m >= 0) {
                    meta = m;
                }
            }
            if (n2.length == 1) {
                itemName = n2[0];
            } else {
                modid = n2[0];
                itemName = n2[1];
            }
        }
        if ((block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modid, itemName))) != null && block != Blocks.field_150350_a) {
            BlockSet set = new BlockSet(block, meta);
            return set;
        }
        DCLogger.debugLog((String)("Failed find target: " + modid + ":" + itemName));
        return OreSetDC.AIR;
    }

    public static int calcTankRedstone(@Nullable TileEntity te) {
        IFluidHandler handler;
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null && handler instanceof DCTank) {
            double max = ((DCTank)handler).getCapacity();
            double cur = ((DCTank)handler).getFluidAmount();
            double d = cur / max;
            return MathHelper.func_76128_c((double)(d * 16.0));
        }
        return 0;
    }
}

